/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettingsConfigurable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerSettings
extends XDebuggerSettings<CidrDebuggerSettings> {
    public boolean RENDERERS_ENABLED = true;
    public boolean VALUES_FILTER_ENABLED = true;
    public boolean COCOA_RENDERERS_ENABLED = true;
    public boolean CORE_DATA_RENDERERS_ENABLED = true;
    public boolean STL_RENDERERS_ENABLED = true;

    @NotNull
    public static CidrDebuggerSettings getInstance() {
        CidrDebuggerSettings cidrDebuggerSettings = (CidrDebuggerSettings)CidrDebuggerSettings.getInstance(CidrDebuggerSettings.class);
        if (cidrDebuggerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings", "getInstance"));
        }
        return cidrDebuggerSettings;
    }

    public CidrDebuggerSettings() {
        super("ObjectiveC");
    }

    public static void updateCurrentDebugSession(AnActionEvent e) {
        XDebugSession session = XDebuggerManager.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).getCurrentSession();
        if (session != null) {
            session.rebuildViews();
        }
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings", "createConfigurables"));
        }
        switch (category) {
            case DATA_VIEWS: {
                List<CidrDebuggerSettingsConfigurable> list = Collections.singletonList(new CidrDebuggerSettingsConfigurable(this));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings", "createConfigurables"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings", "createConfigurables"));
        }
        return list;
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/jetbrains/cidr/execution/debugger/CidrDebuggerSettings", "isTargetedToProduct"));
        }
        return PlatformUtils.isCidr() && "Objective-C".equals(configurable.getDisplayName());
    }

    public CidrDebuggerSettings getState() {
        return this;
    }

    public void loadState(CidrDebuggerSettings state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }
}

