/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggerLanguageSupportFactory {
    public static ExtensionPointName<CidrDebuggerLanguageSupportFactory> EP_NAME = ExtensionPointName.create((String)"cidr.debugger.languageSupportFactory");

    @Nullable
    public abstract XDebuggerEditorsProvider createEditor(RunProfile var1);

    @Nullable
    public abstract XDebuggerEditorsProvider createEditor(XBreakpoint<? extends XBreakpointProperties> var1);

    public abstract CidrDebuggerTypesHelper createTypesHelper(CidrDebugProcess var1);

    @Nullable
    public abstract CidrEvaluator createEvaluator(@NotNull CidrStackFrame var1);

    @Nullable
    public static XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/CidrDebuggerLanguageSupportFactory", "getEditorsProvider"));
        }
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])EP_NAME.getExtensions()) {
            XDebuggerEditorsProvider editorsProvider = factory.createEditor(breakpoint);
            if (editorsProvider == null) continue;
            return editorsProvider;
        }
        return null;
    }
}

