/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.BuildListener;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBuild {
    private static final Semaphore ourBuildSemaphore = new Semaphore(1);

    public static ExecutionResult<Boolean> execute(final @NotNull Project project, final @NotNull BuildContext context, final @NotNull String taskName, final @NotNull Runnable doExecute) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/build/CidrBuild", "execute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/build/CidrBuild", "execute"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/jetbrains/cidr/execution/build/CidrBuild", "execute"));
        }
        if (doExecute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doExecute", "com/jetbrains/cidr/execution/build/CidrBuild", "execute"));
        }
        final Object processCreationLock = new Object();
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            context.indicator = new EmptyProgressIndicator();
        } else {
            final ExecutionResult indicatorResult = new ExecutionResult();
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    new Task.Backgroundable(project, taskName, true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/build/CidrBuild$1$1", "run"));
                            }
                            indicatorResult.set(indicator);
                            boolean wasCanceled = false;
                            while (!context.myResult.isDone()) {
                                if (!wasCanceled && indicator.isCanceled()) {
                                    wasCanceled = true;
                                    Object object = processCreationLock;
                                    synchronized (object) {
                                        ProcessHandler process = context.processHandler;
                                        if (process != null) {
                                            process.destroyProcess();
                                        }
                                    }
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    throw new ProcessCanceledException((Throwable)e);
                                }
                            }
                        }
                    }.queue();
                }
            });
            try {
                context.indicator = (ProgressIndicator)indicatorResult.get();
                context.indicator.setText(CidrBundle.message("build.starting", new Object[0]));
                context.indicator.setText2("");
            }
            catch (ExecutionException e) {
                context.myResult.setException(e);
                return context.myResult;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!context.waitAndStart()) {
                    return;
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = processCreationLock;
                        synchronized (object) {
                            if (context.indicator.isCanceled()) {
                                context.finished(false);
                                return;
                            }
                            MessageView.SERVICE.getInstance(project);
                            FileDocumentManager.getInstance().saveAllDocuments();
                            doExecute.run();
                        }
                    }
                });
            }
        });
        return context.myResult;
    }

    public static void startProcess(final Project project, final @NotNull NotificationGroup logNotificationGroup, final String taskName, final BuildContext context, final @Nullable BuildListener buildListener, final List<File> toRefresh) {
        if (logNotificationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logNotificationGroup", "com/jetbrains/cidr/execution/build/CidrBuild", "startProcess"));
        }
        context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(final ProcessEvent event) {
                context.indicator.setText(CidrBundle.message("build.refreshing", taskName));
                context.indicator.setText2("");
                CidrBuild.refreshFiles(toRefresh, new Runnable(){

                    @Override
                    public void run() {
                        MessageType messageType;
                        if (project.isDisposed()) {
                            return;
                        }
                        boolean buildSucceeded = event.getExitCode() == 0;
                        boolean canceled = context.indicator.isCanceled();
                        context.duration = System.currentTimeMillis() - context.started;
                        context.finished(buildSucceeded);
                        if (canceled) {
                            messageType = MessageType.INFO;
                            context.finishMessage = CidrBundle.message("build.canceled", taskName);
                        } else {
                            boolean hasWarningsOrErrors;
                            boolean bl = hasWarningsOrErrors = context.errors > 0 || context.warnings > 0;
                            messageType = !buildSucceeded ? MessageType.ERROR : (hasWarningsOrErrors ? MessageType.WARNING : MessageType.INFO);
                            context.finishMessage = buildSucceeded ? CidrBundle.message("build.finished", taskName) : CidrBundle.message("build.failed", taskName);
                            context.finishDetails = hasWarningsOrErrors ? CidrBundle.message("build.details", context.errors, context.warnings) : null;
                        }
                        String fullMessage = CidrBuild.showFinishMessage(project, logNotificationGroup, messageType, context.finishMessage, context.finishDetails, context.duration);
                        if (buildListener != null) {
                            buildListener.finished(messageType, fullMessage);
                        }
                    }
                });
            }
        });
        context.processHandler.startNotify();
    }

    public static void refreshFiles(@NotNull Iterable<File> files, @Nullable Runnable onFinish) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/cidr/execution/build/CidrBuild", "refreshFiles"));
        }
        ArrayList virtualFilesToRefresh = new ArrayList();
        for (File each : files) {
            VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(each);
            if (dir == null) continue;
            virtualFilesToRefresh.addAll(VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{dir}));
        }
        LocalFileSystem.getInstance().refreshFiles(virtualFilesToRefresh, true, true, onFinish);
    }

    static String showFinishMessage(Project project, @NotNull NotificationGroup logNotificationGroup, @NotNull MessageType messageType, @NotNull String finishMessage, @Nullable String finishDetails, long time) {
        if (logNotificationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logNotificationGroup", "com/jetbrains/cidr/execution/build/CidrBuild", "showFinishMessage"));
        }
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/jetbrains/cidr/execution/build/CidrBuild", "showFinishMessage"));
        }
        if (finishMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishMessage", "com/jetbrains/cidr/execution/build/CidrBuild", "showFinishMessage"));
        }
        MessageView.SERVICE.getInstance(project);
        String notificationContent = finishMessage + (finishDetails == null ? "" : " with " + finishDetails);
        if (time > 0L) {
            notificationContent = notificationContent + " in " + StringUtil.formatDuration((long)time);
        }
        Notification notification = logNotificationGroup.createNotification(notificationContent, messageType);
        notification.notify(project);
        if (messageType != MessageType.INFO) {
            ToolWindowManager.getInstance((Project)project).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, notificationContent);
        }
        SystemNotifications.getInstance().notify(notification.getGroupId(), StringUtil.capitalizeWords((String)finishMessage, (boolean)true), StringUtil.notNullize((String)finishDetails));
        return notificationContent;
    }

    static Pair<AnAction, Disposable> initializeBuildLog(@NotNull BuildContext context, @NotNull String logName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/build/CidrBuild", "initializeBuildLog"));
        }
        if (logName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logName", "com/jetbrains/cidr/execution/build/CidrBuild", "initializeBuildLog"));
        }
        File file2 = null;
        FileWriter writer = null;
        try {
            file2 = FileUtil.createTempFile((String)logName, (String)".log", (boolean)true);
            writer = new FileWriter(file2);
        }
        catch (IOException e) {
            OCLog.LOG.error("Cannot create build log file", (Throwable)e);
        }
        final File finalFile = file2;
        final FileWriter finalWriter = writer;
        AnAction showBuildLogAction = new AnAction(CidrBundle.message("build.action.showLog", new Object[0]), null, AllIcons.Debugger.Console){

            public void actionPerformed(AnActionEvent event) {
                if (finalFile == null) {
                    return;
                }
                try {
                    Runtime.getRuntime().exec("open " + finalFile.getPath());
                }
                catch (IOException e) {
                    OCLog.LOG.error("Cannot open build log file: " + finalFile, (Throwable)e);
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(finalFile != null);
            }
        };
        if (finalWriter != null) {
            context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    try {
                        finalWriter.write(event.getText());
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }
            });
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (finalWriter != null) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }
                if (finalFile != null) {
                    FileUtil.delete((File)finalFile);
                }
            }
        };
        return Pair.create((Object)showBuildLogAction, (Object)disposable);
    }

    public static class BuildContext {
        @NotNull
        protected final ExecutionResult<Boolean> myResult = new ExecutionResult();
        private final Project myProject;
        @NotNull
        public ProgressIndicator indicator;
        @NotNull
        public ProcessHandler processHandler;
        @Nullable
        public String finishMessage;
        @Nullable
        public String finishDetails;
        public final long started = System.currentTimeMillis();
        public long duration;
        public int errors;
        public int warnings;

        public BuildContext(Project project) {
            this.myProject = project;
        }

        /*
         * Exception decompiling
         */
        public boolean waitAndStart() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void finished(boolean success) {
            ourBuildSemaphore.release();
            this.myResult.set(success);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!BuildContext.this.myProject.isDisposed()) {
                        OCWorkspaceManager.getWorkspace(BuildContext.this.myProject).getModificationTrackers().getBuildsTracker().incModificationCount();
                    }
                }
            });
        }

        public void error(Throwable e) {
            ourBuildSemaphore.release();
            this.myResult.setException(e);
        }
    }
}

