/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.OutputReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GLogOutputReaders {
    public static final Logger LOG = Logger.getInstance(GLogOutputReaders.class);
    private final List<MyLogReader> myReaders = new LinkedList<MyLogReader>();
    private final File myLogDir;
    private final String myLogName;

    public GLogOutputReaders(File logDir, String logName) {
        this.myLogDir = logDir;
        this.myLogName = logName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ExecutionException {
        List<MyLogReader> list = this.myReaders;
        synchronized (list) {
            this.myReaders.add(new MyLogReader(this.myLogDir, this.myLogName, LogType.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<MyLogReader> list = this.myReaders;
        synchronized (list) {
            if (this.myReaders.size() == 0) {
                return;
            }
            for (MyLogReader each : this.myReaders) {
                each.stop();
            }
            for (MyLogReader each : this.myReaders) {
                try {
                    each.waitFor();
                }
                catch (InterruptedException ignore) {
                    LOG.warn((Throwable)ignore);
                    break;
                }
            }
            for (MyLogReader each : this.myReaders) {
                File file2 = each.getFile();
                if (!file2.exists()) continue;
                FileUtil.delete((File)file2);
            }
            this.myReaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully() {
        List<MyLogReader> list = this.myReaders;
        synchronized (list) {
            if (this.myReaders.size() == 0) {
                return;
            }
            for (MyLogReader each : this.myReaders) {
                try {
                    each.readFully();
                }
                catch (InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull LogType var2);

    private class MyLogReader {
        @NotNull
        private final File myFile;
        @NotNull
        private final LogType myType;
        @Nullable
        private volatile OutputReader myReader;
        private volatile boolean closed;

        private MyLogReader(@NotNull File dir, @NotNull String name, LogType type) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader", "<init>"));
            }
            this.myFile = new File(dir, name + "." + type.toString());
            this.myType = type;
            if (this.myFile.exists()) {
                FileUtil.delete((File)this.myFile);
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    while (!MyLogReader.this.closed && !MyLogReader.this.myFile.exists()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Throwable)e);
                            break;
                        }
                    }
                    if (MyLogReader.this.myFile.exists()) {
                        try {
                            MyLogReader.this.start();
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                        }
                    }
                }
            });
        }

        private void start() throws IOException {
            this.myReader = new OutputReader(new FileInputStream(this.myFile), null){

                protected void onTextAvailable(@NotNull String text) {
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader$2", "onTextAvailable"));
                    }
                    GLogOutputReaders.this.onTextAvailable(text, MyLogReader.this.myType);
                }

                protected Future<?> executeOnPooledThread(Runnable runnable2) {
                    return ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                }
            };
        }

        void readFully() throws InterruptedException {
            OutputReader reader = this.myReader;
            if (reader != null) {
                reader.readFully();
            }
        }

        private void stop() {
            OutputReader reader = this.myReader;
            if (reader != null) {
                reader.stop();
            }
            this.closed = true;
        }

        private void waitFor() throws InterruptedException {
            OutputReader reader = this.myReader;
            if (reader != null) {
                reader.waitFor();
            }
        }

        @NotNull
        private File getFile() {
            File file2 = this.myFile;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/GLogOutputReaders$MyLogReader", "getFile"));
            }
            return file2;
        }
    }

    public static enum LogType {
        INFO("INFO"),
        WARNING("WARNING"),
        ERROR("ERROR"),
        FATAL("FATAL");

        private final String myName;

        private LogType(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/GLogOutputReaders$LogType", "<init>"));
            }
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

