/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunner
extends DefaultProgramRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/cidr/execution/CidrRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/cidr/execution/CidrRunner", "canRun"));
        }
        return profile instanceof CidrRunProfile;
    }

    protected static void triggerUsage(@Nullable RunnerAndConfigurationSettings configuration) {
        CidrTestRunConfigurationData delegate;
        String frameworkName;
        RunConfiguration runConfiguration;
        if (configuration != null && (runConfiguration = configuration.getConfiguration()) instanceof CidrTestRunConfiguration && (frameworkName = (delegate = ((CidrTestRunConfiguration)runConfiguration).getTestData()).getTestingFrameworkName()) != null) {
            UsageTrigger.trigger("execute.testingFramework." + ConvertUsagesUtil.ensureProperKey(frameworkName));
        }
    }

    public XDebugSession startDebugSession(final CidrCommandLineState state, ExecutionEnvironment env, final boolean muteBreakpoints, final XDebugSessionListener ... listeners) throws ExecutionException {
        return XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, (XDebugProcessStarter)new XDebugProcessConfiguratorStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/cidr/execution/CidrRunner$1", "start"));
                }
                for (XDebugSessionListener l : listeners) {
                    session.addSessionListener(l);
                }
                XDebugProcess xDebugProcess = state.startDebugProcess(session);
                if (xDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/CidrRunner$1", "start"));
                }
                return xDebugProcess;
            }

            @Override
            public void configure(XDebugSessionData data) {
                if (muteBreakpoints) {
                    data.setBreakpointsMuted(true);
                }
            }
        });
    }
}

