/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunConfiguration<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>>
extends LocatableConfigurationBase
implements CidrRunProfile,
CommonProgramRunConfigurationParameters,
RunConfigurationWithSuppressedDefaultRunAction {
    @Nullable
    private BuildTargetAndConfigurationData myTargetAndConfigurationData;
    @Nullable
    private String myProgramParameters;
    @Nullable
    private String myWorkingDirectory;
    @NotNull
    private Map<String, String> myEnvs = Collections.emptyMap();
    private boolean myPassParentEnvs;

    public CidrRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public String suggestedName() {
        return this.suggestNameForTarget();
    }

    @Nullable
    public String suggestNameForTarget() {
        BuildTargetAndConfigurationData data = this.myTargetAndConfigurationData;
        return data != null && data.target != null ? data.target.targetName : null;
    }

    public void setTargetAndConfigurationData(@Nullable BuildTargetAndConfigurationData data) {
        this.myTargetAndConfigurationData = data;
    }

    @Nullable
    public BuildTargetAndConfigurationData getTargetAndConfigurationData() {
        return this.myTargetAndConfigurationData;
    }

    @Override
    public void setProgramParameters(@Nullable String value) {
        this.myProgramParameters = StringUtil.isEmptyOrSpaces((String)value) ? null : value;
    }

    @Override
    @Nullable
    public String getProgramParameters() {
        return this.myProgramParameters;
    }

    @Override
    public void setWorkingDirectory(@Nullable String value) {
        this.myWorkingDirectory = ExternalizablePath.urlValue(value);
    }

    @Override
    @Nullable
    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue(this.myWorkingDirectory);
    }

    @Override
    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/jetbrains/cidr/execution/CidrRunConfiguration", "setEnvs"));
        }
        this.myEnvs = envs;
    }

    @Override
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/CidrRunConfiguration", "getEnvs"));
        }
        return map;
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    @NotNull
    protected BuildTargetAndConfigurationData createBuildTargetAndConfigurationData(@Nullable String projectName, @Nullable String targetName, @Nullable String configName) {
        BuildTargetAndConfigurationData buildTargetAndConfigurationData = new BuildTargetAndConfigurationData(projectName, targetName, configName);
        if (buildTargetAndConfigurationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/CidrRunConfiguration", "createBuildTargetAndConfigurationData"));
        }
        return buildTargetAndConfigurationData;
    }

    @Override
    @Nullable
    public abstract CidrCommandLineState getState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myProgramParameters = element.getAttributeValue("PROGRAM_PARAMS");
        this.myWorkingDirectory = element.getAttributeValue("WORKING_DIR");
        this.myEnvs = new THashMap();
        EnvironmentVariablesComponent.readExternal(element, this.myEnvs);
        this.myPassParentEnvs = "TRUE".equals(element.getAttributeValue("PASS_PARENT_ENVS"));
        String projectName = element.getAttributeValue("PROJECT_NAME");
        String targetName = element.getAttributeValue("TARGET_NAME");
        String configName = element.getAttributeValue("CONFIG_NAME");
        this.myTargetAndConfigurationData = this.createBuildTargetAndConfigurationData(projectName, targetName, configName);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myProgramParameters != null) {
            element.setAttribute("PROGRAM_PARAMS", this.myProgramParameters);
        }
        if (this.myWorkingDirectory != null) {
            element.setAttribute("WORKING_DIR", this.myWorkingDirectory);
        }
        EnvironmentVariablesComponent.writeExternal(element, this.myEnvs);
        element.setAttribute("PASS_PARENT_ENVS", this.myPassParentEnvs ? "TRUE" : "FALSE");
        if (this.myTargetAndConfigurationData != null) {
            BuildTargetData targetData = this.myTargetAndConfigurationData.target;
            if (targetData != null) {
                element.setAttribute("PROJECT_NAME", targetData.projectName);
                element.setAttribute("TARGET_NAME", targetData.targetName);
            }
            if (this.myTargetAndConfigurationData.configurationName != null) {
                element.setAttribute("CONFIG_NAME", this.myTargetAndConfigurationData.configurationName);
            }
        }
    }

    public RunConfiguration clone() {
        CidrRunConfiguration result2 = (CidrRunConfiguration)super.clone();
        result2.myProgramParameters = this.myProgramParameters;
        result2.myWorkingDirectory = this.myWorkingDirectory;
        result2.myEnvs = new THashMap(this.myEnvs);
        result2.myPassParentEnvs = this.myPassParentEnvs;
        result2.myTargetAndConfigurationData = this.myTargetAndConfigurationData;
        return result2;
    }

    public CidrRunConfiguration setupDefaults() {
        CidrBuildConfigurationHelper<BC, CidrBuildTarget> helper = this.getHelper();
        CidrBuildTarget target = null;
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findRunTarget(data.target);
        }
        if (target == null) {
            target = (CidrBuildTarget)helper.getDefaultTarget();
            data = null;
        }
        String configurationName = null;
        if (data != null && data.configurationName != null) {
            configurationName = data.configurationName;
        } else {
            CidrBuildConfiguration config = helper.getDefaultConfiguration(target);
            if (config != null) {
                configurationName = config.getName();
            }
        }
        this.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(target == null ? null : target.getProjectName(), target == null ? null : target.getName(), configurationName));
        return this;
    }

    @NotNull
    public abstract CidrBuildConfigurationHelper<BC, TARGET> getHelper();
}

