/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ReverseCharSequence;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrPathConsoleFilter
implements Filter {
    public static final int MAX_TIME_PER_LINE = 250;
    private static final String FILE_CHARS = "-+\\p{LC}\\d~._";
    private static final String REVERSE_WIN_FILE_PATH_PATTERN = "^(([-+\\p{LC}\\d~._]+([-+\\p{LC}\\d~._\t ]*(/|\\\\)+)?)+)(:[A-Za-z])?";
    private static final String REVERSE_UNIX_FILE_PATH_PATTERN = "^(([-+\\p{LC}\\d~._]+([-+\\p{LC}\\d~._\t ]*/+)?)+)";
    private static final Pattern ABSOLUTE_WIN_PATH_PREFIX = Pattern.compile("^(/|([A-Za-z]:(\\\\|/))).*");
    private static final String COLON_PATTERN = "[^:]:(\\d{1,5})(\\b|_)";
    private static final int FILE_GROUP = 0;
    private static final int LINE_GROUP = 1;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Pattern myColonPattern;
    @NotNull
    private final Pattern myReverseFilePathPattern;
    @Nullable
    private final CidrToolEnvironment myEnvironment;

    public CidrPathConsoleFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "<init>"));
        }
        this(project, null);
    }

    public CidrPathConsoleFilter(@NotNull Project project, @Nullable CidrToolEnvironment environment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "<init>"));
        }
        this.myColonPattern = Pattern.compile(COLON_PATTERN);
        this.myReverseFilePathPattern = Pattern.compile(SystemInfo.isWindows ? REVERSE_WIN_FILE_PATH_PATTERN : REVERSE_UNIX_FILE_PATH_PATTERN);
        this.myProject = project;
        this.myEnvironment = environment;
    }

    @Nullable
    public Filter.Result applyFilter(@Nullable String line, int entireLength) {
        if (line == null) {
            return null;
        }
        CharSequence expiringLine = CidrPathConsoleFilter.timeLimitedSequence(line);
        Matcher cm = this.myColonPattern.matcher(expiringLine);
        Matcher fm = null;
        List results = null;
        int searchPosition = 0;
        int lineStart = entireLength - line.length();
        try {
            while (cm.find(searchPosition)) {
                int pathStart;
                String filename;
                HyperlinkInfo link;
                int lineNumber;
                int fileSearchPosition = searchPosition;
                searchPosition = cm.start(1);
                try {
                    lineNumber = Integer.valueOf(cm.group(1));
                    lineNumber = lineNumber > 0 ? lineNumber - 1 : lineNumber;
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
                if (fm == null) {
                    fm = this.myReverseFilePathPattern.matcher((CharSequence)new ReverseCharSequence(expiringLine));
                }
                fm.region(line.length() - cm.start() - 1, line.length() - fileSearchPosition);
                if (!fm.find() || (link = this.processMatch(filename = line.substring(pathStart = line.length() - fm.end(0), line.length() - fm.start()), lineNumber, 0)) == null) continue;
                if (results == null) {
                    results = ContainerUtil.newSmartList();
                }
                results.add(new Filter.ResultItem(lineStart + pathStart, lineStart + cm.end(1), link));
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return results == null || results.size() == 0 ? null : new Filter.Result(results);
    }

    private static CharSequence timeLimitedSequence(String line) {
        final long expirationTime = System.currentTimeMillis() + 250L;
        return new StringUtil.BombedCharSequence(line){

            protected void checkCanceled() {
                if (System.currentTimeMillis() > expirationTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    @Nullable
    protected HyperlinkInfo processMatch(@NotNull String matchedPath, int line, int column) {
        VirtualFile file2;
        String path;
        boolean hasSeparator;
        if (matchedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchedPath", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "processMatch"));
        }
        boolean isAbsolute = SystemInfo.isWindows ? ABSOLUTE_WIN_PATH_PREFIX.matcher(matchedPath).matches() : matchedPath.startsWith("/");
        boolean isHomePath = !isAbsolute && !SystemInfo.isWindows && matchedPath.startsWith("~");
        boolean bl = hasSeparator = !isHomePath && (matchedPath.contains(File.separator) || SystemInfo.isWindows && matchedPath.contains("/"));
        if (this.myEnvironment != null && (isAbsolute || hasSeparator) && (path = this.myProject.getBaseDir().getCanonicalPath()) != null) {
            matchedPath = this.myEnvironment.toLocalPath(new File(path), matchedPath);
            isAbsolute = true;
        }
        if (isAbsolute) {
            file2 = CidrPathConsoleFilter.fileByIOFile(new File(matchedPath));
        } else if (isHomePath) {
            String userHome = System.getProperty("user.home");
            file2 = CidrPathConsoleFilter.fileByIOFile(new File(userHome, matchedPath.substring(1)));
        } else {
            file2 = hasSeparator ? CidrPathConsoleFilter.fileByIOFile(new File(this.myProject.getBaseDir().getCanonicalPath(), matchedPath)) : this.findFirstFileByName(matchedPath);
        }
        return file2 == null ? null : this.createHyperlinkInfo(file2, line, column);
    }

    @NotNull
    protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file2, int line, int column) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "createHyperlinkInfo"));
        }
        OpenFileHyperlinkInfo openFileHyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, file2, line, column);
        if (openFileHyperlinkInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "createHyperlinkInfo"));
        }
        return openFileHyperlinkInfo;
    }

    @Nullable
    private static VirtualFile fileByIOFile(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "fileByIOFile"));
        }
        return ioFile.exists() ? LocalFileSystem.getInstance().findFileByPath(ioFile.getAbsolutePath()) : null;
    }

    @Nullable
    private VirtualFile findFirstFileByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/CidrPathConsoleFilter", "findFirstFileByName"));
        }
        return (VirtualFile)ContainerUtil.getFirstItem(FilenameIndex.getVirtualFilesByName(this.myProject, name, GlobalSearchScope.projectScope((Project)this.myProject)));
    }
}

