/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.execution.CidrPathConsoleFilter;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import org.jetbrains.annotations.NotNull;

public class CidrConsoleBuilder
extends TextConsoleBuilderImpl {
    public CidrConsoleBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/CidrConsoleBuilder", "<init>"));
        }
        super(project);
        this.init(project);
    }

    private void init(Project project) {
        this.addFilter(new CidrPathConsoleFilter(project));
    }

    protected ConsoleView createConsole(@NotNull ConfigurationType type, SMTRunnerConsoleProperties consoleProperties) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/CidrConsoleBuilder", "createConsole"));
        }
        SMTRunnerConsoleView console = (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createConsole(type.getId(), consoleProperties);
        Disposer.register((Disposable)this.getProject(), (Disposable)console);
        console.getResultsViewer().getTreeView().getSelectionModel().setSelectionMode(4);
        console.addMessageFilter((Filter)new RegexpFilter(this.getProject(), "$FILE_PATH$:$LINE$:\\.*"){

            protected HyperlinkInfo createOpenFileHyperlink(String path, int line, int column) {
                return super.createOpenFileHyperlink(CidrTestUtil.normalizePath(path), line, column);
            }
        });
        return console;
    }
}

