/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildTargetAndConfigurationData {
    @Nullable
    public final BuildTargetData target;
    @Nullable
    public final String configurationName;

    public BuildTargetAndConfigurationData(@Nullable BuildTargetData target, @Nullable String configurationName) {
        this.target = target;
        this.configurationName = configurationName;
    }

    public BuildTargetAndConfigurationData(@Nullable String projectName, @Nullable String targetName, @Nullable String configurationName) {
        this(projectName == null || targetName == null ? null : new BuildTargetData(projectName, targetName), configurationName);
    }

    public BuildTargetAndConfigurationData(@Nullable CidrBuildTarget target, @Nullable String configurationName) {
        this(target == null ? null : target.getProjectName(), target == null ? null : target.getName(), configurationName);
    }

    public BuildTargetAndConfigurationData(@Nullable CidrBuildTarget target, @Nullable CidrBuildConfiguration configuration) {
        this(target, configuration == null ? null : configuration.getName());
    }

    public BuildTargetAndConfigurationData() {
        this(null, null, null);
    }

    public String toString() {
        return this.getDisplayString();
    }

    @NotNull
    public String getDisplayString() {
        String string = BuildTargetAndConfigurationData.formatDisplayString(this.target == null ? null : this.target.projectName, this.target == null ? null : this.target.targetName, this.configurationName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData", "getDisplayString"));
        }
        return string;
    }

    @Contract(value="null, _ -> false")
    public static boolean checkData(@Nullable BuildTargetAndConfigurationData data, @Nullable BuildConfigurationProblems problems) {
        return BuildTargetAndConfigurationData.checkData(data, problems, false);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean checkData(@Nullable BuildTargetAndConfigurationData data, @Nullable BuildConfigurationProblems problems, boolean allowEmptyTarget) {
        String configurationName;
        BuildTargetData target = data != null ? data.target : null;
        String string = configurationName = data != null ? data.configurationName : null;
        if (problems != null) {
            problems.title = CidrBundle.message("build.configuration.invalid", new Object[0]);
        }
        if (target == null && !allowEmptyTarget || configurationName == null) {
            if (problems != null) {
                if (target == null && !allowEmptyTarget) {
                    problems.problems.add(CidrBundle.message("build.configuration.parameterNotSelected", CidrBundle.message("build.configuration.target", new Object[0])));
                }
                if (configurationName == null) {
                    problems.problems.add(CidrBundle.message("build.configuration.parameterNotSelected", CidrBundle.message("build.configuration.configuration", new Object[0])));
                }
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTargetAndConfigurationData that = (BuildTargetAndConfigurationData)o;
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return !(this.configurationName != null ? !this.configurationName.equals(that.configurationName) : that.configurationName != null);
    }

    public int hashCode() {
        int result2 = this.target != null ? this.target.hashCode() : 0;
        result2 = 31 * result2 + (this.configurationName != null ? this.configurationName.hashCode() : 0);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String formatDisplayString(@Nullable String projectName, @Nullable String targetName, @Nullable String configName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        String string = builder.append(BuildTargetAndConfigurationData.formatDisplayString(projectName, targetName)).append(" - ").append(configName).toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData", "formatDisplayString"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String formatDisplayString(@Nullable String projectName, @Nullable String targetName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        String string = builder.append(targetName).append(" (").append(projectName).append(")").toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData", "formatDisplayString"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }
}

