/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildConfigurationProblems {
    @NotNull
    public String title;
    @NotNull
    public final List<String> problems = new SmartList();
    @NotNull
    public final List<Fix> fixes = new SmartList();

    @NotNull
    public String getTitle() {
        String string = this.title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems", "getTitle"));
        }
        return string;
    }

    @NotNull
    public List<String> getProblems() {
        List<String> list = this.problems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems", "getProblems"));
        }
        return list;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @NotNull
    public String getHtmlProblems() {
        String string = StringUtil.join(this.problems, (String)"<br>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems", "getHtmlProblems"));
        }
        return string;
    }

    @NotNull
    public String getTextProblems() {
        String string = StringUtil.join(this.problems, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems", "getTextProblems"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String result2 = this.getTitle();
        if (this.hasProblems()) {
            result2 = result2 + "\n" + this.getTextProblems();
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems", "getText"));
        }
        return string;
    }

    @NotNull
    public List<Fix> getFixes() {
        List<Fix> list = this.fixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems", "getFixes"));
        }
        return list;
    }

    @Nullable
    public Fix findFix(@Nullable String name) {
        for (Fix each : this.fixes) {
            if (!each.name.equals(name)) continue;
            return each;
        }
        return null;
    }

    public static abstract class Fix {
        @NotNull
        private final String name;
        private final boolean special;

        protected Fix(@NotNull String name, boolean special) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/execution/BuildConfigurationProblems$Fix", "<init>"));
            }
            this.name = name;
            this.special = special;
        }

        public abstract void apply();

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildConfigurationProblems$Fix", "getName"));
            }
            return string;
        }
    }
}

