/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ToolVersion
extends Version {
    public final String versionString;
    public static final String UNKNOWN_VERSION = "unknown";
    public static final ToolVersion UNKNOWN = new ToolVersion("unknown", 0, 0, 0);

    public ToolVersion(int major, int minor, int bugfix) {
        this(Version.toCompactString((int)major, (int)minor, (int)bugfix), major, minor, bugfix);
    }

    public ToolVersion(String versionString, int major, int minor, int bugfix) {
        super(major, minor, bugfix);
        this.versionString = versionString;
    }

    @NotNull
    public static ToolVersion parse(@NotNull String version, Pattern ... patterns) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/cidr/ToolVersion", "parse"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/jetbrains/cidr/ToolVersion", "parse"));
        }
        String[] versions = null;
        for (Pattern pattern : patterns) {
            String versionGroup;
            Matcher matcher = pattern.matcher(version);
            if (!matcher.find() || (versionGroup = matcher.group(1)) == null) continue;
            versions = versionGroup.split("\\.");
            break;
        }
        if (versions == null || versions.length < 2) {
            ToolVersion toolVersion = UNKNOWN;
            if (toolVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/ToolVersion", "parse"));
            }
            return toolVersion;
        }
        ToolVersion toolVersion = new ToolVersion(version, Integer.parseInt((String)versions[0]), Integer.parseInt((String)versions[1]), versions.length > 2 ? Integer.parseInt(versions[2]) : 0);
        if (toolVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/ToolVersion", "parse"));
        }
        return toolVersion;
    }

    public String toString() {
        return this.versionString;
    }

    public String toCompactString() {
        if (this.isUnknown()) {
            return UNKNOWN_VERSION;
        }
        return super.toCompactString();
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ToolVersion version = (ToolVersion)((Object)o);
        return !(this.versionString != null ? !this.versionString.equals(version.versionString) : version.versionString != null);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.versionString != null ? this.versionString.hashCode() : 0);
        return result2;
    }
}

