/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper {
    private final Key<VirtualFile> myOpenFileKey;
    private final FileType[] mySupportedTypes;

    public ProjectOpenHelper(@NotNull Key<VirtualFile> openFileKey, FileType ... supportedTypes) {
        if (openFileKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "openFileKey", "com/jetbrains/cidr/ProjectOpenHelper", "<init>"));
        }
        this.myOpenFileKey = openFileKey;
        this.mySupportedTypes = supportedTypes;
    }

    public boolean canOpenProject(@Nullable VirtualFile file2) {
        return file2 != null && this.isSupportedFile(file2.getFileType());
    }

    public boolean canOpenProject(@Nullable String fileName) {
        return fileName != null && this.isSupportedFile(FileTypeRegistry.getInstance().getFileTypeByFileName(fileName));
    }

    private boolean isSupportedFile(@Nullable FileType type) {
        return Arrays.asList(this.mySupportedTypes).contains(type);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/cidr/ProjectOpenHelper", "openProject"));
        }
        if (!this.canOpenProject(virtualFile)) {
            return null;
        }
        virtualFile.refresh(false, true);
        VirtualFile baseDir = virtualFile.getParent();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!Comparing.equal((Object)baseDir, (Object)project.getBaseDir())) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        baseDir.putUserData(this.myOpenFileKey, (Object)virtualFile);
        return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, projectToClose, forceOpenInNewFrame);
    }

    @Nullable
    public VirtualFile getAndClearFileToOpen(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/ProjectOpenHelper", "getAndClearFileToOpen"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        VirtualFile fileToOpen = (VirtualFile)baseDir.getUserData(this.myOpenFileKey);
        baseDir.putUserData(this.myOpenFileKey, null);
        return fileToOpen;
    }
}

