/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import org.jetbrains.annotations.Nullable;

public class ContextFreeResolveUtil {
    @Nullable
    public static OCClassSymbol resolveToClass(String className, Project project) {
        final Ref resolution = new Ref();
        final String finalClassName = className;
        OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, new Processor<OCSymbol>(){

            public boolean process(OCSymbol ocSymbol) {
                if (ocSymbol instanceof OCClassSymbol && ocSymbol.getName().equals(finalClassName) && !ocSymbol.isPredeclaration() && ((OCClassSymbol)ocSymbol).getCategoryName() == null) {
                    resolution.set((Object)((OCClassSymbol)ocSymbol));
                    return false;
                }
                return true;
            }
        }, className);
        return (OCClassSymbol)resolution.get();
    }

    @Nullable
    public static OCMemberSymbol resolveToProperty(String className, String property, Project project) {
        if (className == null) {
            return null;
        }
        OCClassSymbol symbol = ContextFreeResolveUtil.resolveToClass(className, project);
        return ContextFreeResolveUtil.resolveToProperty(property, symbol);
    }

    public static OCMemberSymbol resolveToProperty(String property, OCClassSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        symbol.processMembers(property, (Processor<OCMemberSymbol>)processor2);
        return (OCMemberSymbol)processor2.getFoundValue();
    }
}

