/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairConvertor;
import com.intellij.util.containers.EncoderDecoder;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.SchemaTypeInfo;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdComplexTypeInfoBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SchemaTypeInheritanceIndex
extends XmlIndex<Set<SchemaTypeInfo>> {
    private static final ID<String, Set<SchemaTypeInfo>> NAME = ID.create((String)"SchemaTypeInheritance");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.index.SchemaTypeInheritanceIndex");

    private static List<Set<SchemaTypeInfo>> getDirectChildrenOfType(Project project, String ns, String name) {
        GlobalSearchScope filter = SchemaTypeInheritanceIndex.createFilter(project);
        List list = FileBasedIndex.getInstance().getValues(NAME, (Object)NsPlusTag.INSTANCE.encode((Pair<String, String>)Pair.create((Object)ns, (Object)name)), filter);
        return list;
    }

    public static PairConvertor<String, String, List<Set<SchemaTypeInfo>>> getWorker(Project project, VirtualFile currentFile) {
        return new MyWorker(currentFile, project);
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @NotNull
    public ID<String, Set<SchemaTypeInfo>> getName() {
        ID<String, Set<SchemaTypeInfo>> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/SchemaTypeInheritanceIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Set<SchemaTypeInfo>, FileContent> getIndexer() {
        DataIndexer<String, Set<SchemaTypeInfo>, FileContent> dataIndexer = new DataIndexer<String, Set<SchemaTypeInfo>, FileContent>(){

            @NotNull
            public Map<String, Set<SchemaTypeInfo>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/xml/index/SchemaTypeInheritanceIndex$1", "map"));
                }
                HashMap map = new HashMap();
                MultiMap<SchemaTypeInfo, SchemaTypeInfo> multiMap = XsdComplexTypeInfoBuilder.parse(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                for (SchemaTypeInfo key : multiMap.keySet()) {
                    map.put(NsPlusTag.INSTANCE.encode((Pair<String, String>)Pair.create((Object)key.getNamespaceUri(), (Object)key.getTagName())), new HashSet(multiMap.get((Object)key)));
                }
                HashMap hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/SchemaTypeInheritanceIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/SchemaTypeInheritanceIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<Set<SchemaTypeInfo>> getValueExternalizer() {
        DataExternalizer<Set<SchemaTypeInfo>> dataExternalizer = new DataExternalizer<Set<SchemaTypeInfo>>(){

            public void save(@NotNull DataOutput out, Set<SchemaTypeInfo> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/xml/index/SchemaTypeInheritanceIndex$2", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (SchemaTypeInfo key : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)key.getNamespaceUri());
                    IOUtil.writeUTF((DataOutput)out, (String)key.getTagName());
                    out.writeBoolean(key.isIsTypeName());
                }
            }

            public Set<SchemaTypeInfo> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/xml/index/SchemaTypeInheritanceIndex$2", "read"));
                }
                HashSet<SchemaTypeInfo> set = new HashSet<SchemaTypeInfo>();
                int size = DataInputOutputUtil.readINT((DataInput)in);
                for (int i = 0; i < size; ++i) {
                    String nsUri = IOUtil.readUTF((DataInput)in);
                    String tagName = IOUtil.readUTF((DataInput)in);
                    boolean isType = in.readBoolean();
                    set.add(new SchemaTypeInfo(tagName, isType, nsUri));
                }
                return set;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/SchemaTypeInheritanceIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    private static class NsPlusTag
    implements EncoderDecoder<Pair<String, String>, String> {
        private static final NsPlusTag INSTANCE = new NsPlusTag();
        private static final char ourSeparator = ':';

        private NsPlusTag() {
        }

        public String encode(Pair<String, String> pair) {
            return (String)pair.getFirst() + ':' + (String)pair.getSecond();
        }

        public Pair<String, String> decode(String s) {
            int i = s.indexOf(58);
            return i <= 0 ? Pair.create((Object)"", (Object)s) : Pair.create((Object)s.substring(0, i), (Object)s.substring(i + 1));
        }
    }

    private static class MyWorker
    implements PairConvertor<String, String, List<Set<SchemaTypeInfo>>> {
        private final Project myProject;
        private final VirtualFile myCurrentFile;
        private final GlobalSearchScope myFilter;
        private final boolean myShouldParseCurrent;
        private MultiMap<SchemaTypeInfo, SchemaTypeInfo> myMap;

        private MyWorker(VirtualFile currentFile, Project project) {
            this.myCurrentFile = currentFile;
            this.myProject = project;
            this.myFilter = XmlIndex.createFilter(project);
            this.myShouldParseCurrent = this.myCurrentFile != null && !this.myFilter.contains(this.myCurrentFile);
        }

        public List<Set<SchemaTypeInfo>> convert(String ns, String name) {
            List type = SchemaTypeInheritanceIndex.getDirectChildrenOfType(this.myProject, ns, name);
            if (this.myShouldParseCurrent && this.myMap == null) {
                try {
                    this.myMap = XsdComplexTypeInfoBuilder.parse(CharArrayUtil.readerFromCharSequence((CharSequence)VfsUtilCore.loadText((VirtualFile)this.myCurrentFile)));
                    type.add(new HashSet(this.myMap.get((Object)new SchemaTypeInfo(name, true, ns))));
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            return type;
        }
    }
}

