/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ParameterizedCachedValueImpl;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import io.netty.util.collection.IntObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    private static ParameterizedCachedValueImpl<IntObjectHashMap<String>, PsiFile> ESCAPES = new ParameterizedCachedValueImpl<IntObjectHashMap<String>, PsiFile>((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<IntObjectHashMap<String>, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<IntObjectHashMap<String>> compute(PsiFile param) {
            XmlFile file2 = XmlUtil.findXmlFile(param, Html5SchemaProvider.getCharsDtdLocation());
            assert (file2 != null);
            final IntObjectHashMap result2 = new IntObjectHashMap();
            XmlUtil.processXmlElements((XmlElement)file2, new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    String value;
                    Integer key;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/actions/EscapeEntitiesAction$1$1", "execute"));
                    }
                    if (element instanceof XmlEntityDecl && !result2.containsKey((Object)(key = Integer.valueOf((value = ((XmlEntityDecl)element).getValueElement().getValue()).substring(2, value.length() - 1))))) {
                        result2.put(key, (Object)((XmlEntityDecl)element).getName());
                    }
                    return true;
                }
            }, true);
            return new CachedValueProvider.Result((Object)result2, new Object[]{ModificationTracker.NEVER_CHANGED});
        }
    }){

        @Override
        public boolean isFromMyProject(Project project) {
            return true;
        }
    };

    private static String escape(XmlFile file2, String text, int start) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String escape;
            char c = text.charAt(i);
            PsiElement element = file2.findElementAt(start + i);
            if (element != null && EscapeEntitiesAction.isCharacterElement(element) && (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c > '\u007f') && (escape = (String)ESCAPES.getValue((PsiFile)file2).get((int)c)) != null) {
                result2.append("&").append(escape).append(";");
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    private static boolean isCharacterElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/EscapeEntitiesAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/EscapeEntitiesAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/EscapeEntitiesAction", "isValidForFile"));
        }
        return file2 instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        EscapeEntitiesAction escapeEntitiesAction = this;
        if (escapeEntitiesAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/actions/EscapeEntitiesAction", "getHandler"));
        }
        return escapeEntitiesAction;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/EscapeEntitiesAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/EscapeEntitiesAction", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/EscapeEntitiesAction", "invoke"));
        }
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        final Document document = editor.getDocument();
        for (int i = starts.length - 1; i >= 0; --i) {
            String newText;
            final int start = starts[i];
            final int end = ends[i];
            String oldText = document.getText(new TextRange(start, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape((XmlFile)file2, oldText, start))) continue;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    document.replaceString(start, end, (CharSequence)newText);
                }
            });
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

