/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RollbackUtil {
    private RollbackUtil() {
    }

    @NotNull
    public static String getRollbackOperationName(@NotNull Collection<AbstractVcs> vcses) {
        if (vcses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcses", "com/intellij/vcsUtil/RollbackUtil", "getRollbackOperationName"));
        }
        String operationName = null;
        for (AbstractVcs vcs : vcses) {
            RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
            if (rollbackEnvironment == null) continue;
            if (operationName == null) {
                operationName = rollbackEnvironment.getRollbackOperationName();
                continue;
            }
            if (operationName.equals(rollbackEnvironment.getRollbackOperationName())) continue;
            String string = DefaultRollbackEnvironment.ROLLBACK_OPERATION_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcsUtil/RollbackUtil", "getRollbackOperationName"));
            }
            return string;
        }
        String string = operationName != null ? operationName : DefaultRollbackEnvironment.ROLLBACK_OPERATION_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcsUtil/RollbackUtil", "getRollbackOperationName"));
        }
        return string;
    }

    @NotNull
    public static String getRollbackOperationName(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcsUtil/RollbackUtil", "getRollbackOperationName"));
        }
        String string = RollbackUtil.getRollbackOperationName(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcsUtil/RollbackUtil", "getRollbackOperationName"));
        }
        return string;
    }
}

