/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.util.indexing.ValueContainer;

public class SortedFileIdSetIterator
implements ValueContainer.IntIterator {
    private final int[] myBits;
    private final int myBitsLength;
    private final int myOffset;
    private int myPosition;
    private final int mySize;
    private static final ThreadLocalCachedIntArray ourSpareBuffer = new ThreadLocalCachedIntArray();
    private static final int INT_BITS_SHIFT = 5;

    private SortedFileIdSetIterator(int[] bits, int bitsLength, int offset, int size) {
        this.myBits = bits;
        this.myBitsLength = bitsLength;
        this.myOffset = offset;
        this.myPosition = SortedFileIdSetIterator.nextSetBit(0, this.myBits, this.myBitsLength);
        this.mySize = size;
    }

    @Override
    public boolean hasNext() {
        return this.myPosition != -1;
    }

    @Override
    public int next() {
        int next = this.myPosition + this.myOffset;
        this.myPosition = SortedFileIdSetIterator.nextSetBit(this.myPosition + 1, this.myBits, this.myBitsLength);
        return next;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean hasAscendingOrder() {
        return true;
    }

    @Override
    public ValueContainer.IntIterator createCopyInInitialState() {
        return new SortedFileIdSetIterator(this.myBits, this.myBitsLength, this.myOffset, this.mySize);
    }

    public static ValueContainer.IntIterator getTransientIterator(ValueContainer.IntIterator intIterator) {
        ValueContainer.IntIterator intIteratorConed = intIterator.createCopyInInitialState();
        int max = 0;
        int min = Integer.MAX_VALUE;
        while (intIterator.hasNext()) {
            int nextInt = intIterator.next();
            max = Math.max(max, nextInt);
            min = Math.min(min, nextInt);
        }
        assert (min > 0);
        int offset = min >> 5 << 5;
        int bitsLength = (max - offset >> 5) + 1;
        int[] bits = ourSpareBuffer.getBuffer(bitsLength);
        for (int i = 0; i < bitsLength; ++i) {
            bits[i] = 0;
        }
        intIterator = intIteratorConed;
        int size = 0;
        while (intIterator.hasNext()) {
            int id = intIterator.next() - offset;
            int n = id >> 5;
            bits[n] = bits[n] | 1 << id;
            ++size;
        }
        return new SortedFileIdSetIterator(bits, bitsLength, offset, size);
    }

    private static int nextSetBit(int bitIndex, int[] bits, int bitsLength) {
        int wordIndex = bitIndex >> 5;
        if (wordIndex >= bitsLength) {
            return -1;
        }
        int word = bits[wordIndex] & -1 << bitIndex;
        while (word == 0) {
            if (++wordIndex == bitsLength) {
                return -1;
            }
            word = bits[wordIndex];
        }
        return (wordIndex << 5) + Long.numberOfTrailingZeros(word);
    }
}

