/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public class DocumentBasedReplaceHandler
extends StructuralReplaceHandler {
    private final Project myProject;
    private final Map<ReplacementInfo, RangeMarker> myRangeMarkers = new HashMap();

    DocumentBasedReplaceHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void replace(ReplacementInfo info, ReplaceOptions options) {
        PsiFile file2;
        if (info.getMatchesCount() == 0) {
            return;
        }
        assert (info instanceof ReplacementInfoImpl);
        PsiElement element = info.getMatch(0);
        if (element == null) {
            return;
        }
        PsiFile psiFile = file2 = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        assert (file2 != null);
        RangeMarker rangeMarker = this.myRangeMarkers.get(info);
        Document document = rangeMarker.getDocument();
        document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)info.getReplacement());
        PsiDocumentManager.getInstance((Project)element.getProject()).commitDocument(document);
    }

    @Override
    public void prepare(ReplacementInfo info) {
        assert (info instanceof ReplacementInfoImpl);
        MatchResult result2 = ((ReplacementInfoImpl)info).getMatchResult();
        PsiElement element = result2.getMatch();
        PsiFile file2 = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        TextRange textRange = result2.getMatchRef().getElement().getTextRange();
        assert (textRange != null);
        RangeMarker rangeMarker = document.createRangeMarker(textRange);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.myRangeMarkers.put(info, rangeMarker);
    }
}

