/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ui.UsagesPanel;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Set;

public class MigrationUsagesPanel
extends UsagesPanel {
    public MigrationUsagesPanel(Project project) {
        super(project);
    }

    @Override
    public String getInitialPositionText() {
        return "Select root to find reasons to migrate";
    }

    @Override
    public String getCodeUsagesString() {
        return "Found reasons to migrate";
    }

    public void showRootUsages(UsageInfo root, UsageInfo migration, TypeMigrationLabeler labeler) {
        PsiElement rootElement = root.getElement();
        if (rootElement == null) {
            return;
        }
        Set<PsiElement> usages = labeler.getTypeUsages((TypeMigrationUsageInfo)migration, (TypeMigrationUsageInfo)root);
        if (usages != null) {
            ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>(usages.size());
            for (PsiElement usage : usages) {
                if (usage == null || !usage.isValid()) continue;
                infos.add(new UsageInfo(usage));
            }
            this.showUsages(new PsiElement[]{rootElement}, infos.toArray(new UsageInfo[infos.size()]));
        } else {
            this.showUsages(new PsiElement[]{rootElement}, new UsageInfo[]{migration});
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(-1, 300);
    }
}

