/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteCustomUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class SafeDeleteParameterCallHierarchyUsageInfo
extends SafeDeleteUsageInfo
implements SafeDeleteCustomUsageInfo {
    private final PsiMethod myCalledMethod;
    private final PsiMethod myCallerMethod;

    public SafeDeleteParameterCallHierarchyUsageInfo(PsiMethod calledMethod, PsiParameter parameter, PsiMethod callerMethod) {
        super((PsiElement)calledMethod, (PsiElement)parameter);
        this.myCalledMethod = calledMethod;
        this.myCallerMethod = callerMethod;
    }

    public PsiParameter getReferencedElement() {
        return (PsiParameter)super.getReferencedElement();
    }

    @Override
    public void performRefactoring() throws IncorrectOperationException {
        PsiParameter parameter = this.getReferencedElement();
        if (parameter != null && parameter.isValid()) {
            parameter.delete();
        }
    }

    public PsiMethod getCalledMethod() {
        return this.myCalledMethod;
    }

    public PsiMethod getCallerMethod() {
        return this.myCallerMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeDeleteParameterCallHierarchyUsageInfo info = (SafeDeleteParameterCallHierarchyUsageInfo)o;
        if (!this.myCalledMethod.equals(info.myCalledMethod)) {
            return false;
        }
        return this.myCallerMethod.equals(info.myCallerMethod);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myCalledMethod.hashCode();
        result2 = 31 * result2 + this.myCallerMethod.hashCode();
        return result2;
    }
}

