/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.AbstractMakeStaticDialog;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeParameterizedStaticDialog;
import com.intellij.refactoring.makeStatic.MakeStaticUtil;
import com.intellij.refactoring.makeStatic.SimpleMakeStaticDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeStaticHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"make.method.static.title");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.makeMethodStatic.MakeMethodStaticHandler");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/makeStatic/MakeStaticHandler", "invoke"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file2.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiTypeParameterListOwner)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.makeMethodStatic");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MakeStaticHandler invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/makeStatic/MakeStaticHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/makeStatic/MakeStaticHandler", "invoke"));
        }
        if (elements.length != 1 || !(elements[0] instanceof PsiTypeParameterListOwner)) {
            return;
        }
        PsiTypeParameterListOwner member = (PsiTypeParameterListOwner)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)member)) {
            return;
        }
        String error = MakeStaticHandler.validateTarget(member);
        if (error != null) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error, (String)REFACTORING_NAME, (String)"refactoring.makeMethodStatic");
            return;
        }
        MakeStaticHandler.invoke(member);
    }

    public static void invoke(final PsiTypeParameterListOwner member) {
        Project project = member.getProject();
        InternalUsageInfo[] classRefsInMember = MakeStaticUtil.findClassRefsInMember(member, false);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractMakeStaticDialog dialog;
            final boolean[] hasMethodReferenceOnInstance = new boolean[]{false};
            if (member instanceof PsiMethod && !ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    hasMethodReferenceOnInstance[0] = !MethodReferencesSearch.search((PsiMethod)((PsiMethod)member)).forEach((Processor)new Processor<PsiReference>(){

                        public boolean process(PsiReference reference) {
                            PsiElement element = reference.getElement();
                            return !(element instanceof PsiMethodReferenceExpression);
                        }
                    });
                }
            }, "Search for method references", true, project)) {
                return;
            }
            if (classRefsInMember.length > 0 || hasMethodReferenceOnInstance[0]) {
                PsiClassType type = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(member.getContainingClass());
                String[] nameSuggestions = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names;
                dialog = new MakeParameterizedStaticDialog(project, member, nameSuggestions, classRefsInMember);
            } else {
                dialog = new SimpleMakeStaticDialog(project, member);
            }
            dialog.show();
        }
    }

    @Nullable
    public static String validateTarget(PsiTypeParameterListOwner member) {
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"constructor.cannot.be.made.static"));
        }
        if (member.getContainingClass() == null) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"this.member.does.not.seem.to.belong.to.any.class"));
        }
        if (member.hasModifierProperty("static")) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"member.is.already.static"));
        }
        if (member instanceof PsiMethod && member.hasModifierProperty("abstract")) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.make.abstract.method.static"));
        }
        if (containingClass instanceof PsiAnonymousClass || containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"inner.classes.cannot.have.static.members"));
        }
        return null;
    }
}

