/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineLocalDialog;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineLocalHandler
extends JavaInlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineLocalHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.variable.title");

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiLocalVariable;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference psiReference = TargetElementUtil.findReference(editor);
        PsiReferenceExpression refExpr = psiReference instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiReference : null;
        InlineLocalHandler.invoke(project, editor, (PsiLocalVariable)element, refExpr);
    }

    public static void invoke(@NotNull Project project, Editor editor, final PsiLocalVariable local, PsiReferenceExpression refExpr) {
        PsiExpression defToInline;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/inline/InlineLocalHandler", "invoke"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)local)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String localName = local.getName();
        Query query = ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)false);
        if (query.findFirst() == null) {
            LOG.assertTrue(refExpr == null);
            String message = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        final PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)local, PsiClass.class);
        final List innerClassesWithUsages = Collections.synchronizedList(new ArrayList());
        final List<PsiElement> innerClassUsages = Collections.synchronizedList(new ArrayList());
        query.forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                PsiElement element = psiReference.getElement();
                PsiElement innerClass = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                while (innerClass != containingClass && innerClass != null) {
                    PsiClass parentPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)innerClass, PsiClass.class, (boolean)true);
                    if (parentPsiClass == containingClass) {
                        if (innerClass instanceof PsiLambdaExpression) {
                            if (PsiTreeUtil.isAncestor((PsiElement)innerClass, (PsiElement)local, (boolean)false)) {
                                innerClassesWithUsages.add(element);
                            } else {
                                innerClassesWithUsages.add(innerClass);
                            }
                            innerClass = parentPsiClass;
                            continue;
                        }
                        innerClassesWithUsages.add(innerClass);
                        innerClassUsages.add(element);
                    }
                    innerClass = parentPsiClass;
                }
                return true;
            }
        });
        PsiCodeBlock containerBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)local, PsiCodeBlock.class);
        if (containerBlock == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)"Variable is declared outside a code block");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        PsiExpression psiExpression = defToInline = innerClassesWithUsages.isEmpty() ? InlineLocalHandler.getDefToInline((PsiVariable)local, (PsiElement)refExpr, containerBlock) : InlineLocalHandler.getDefToInline((PsiVariable)local, (PsiElement)innerClassesWithUsages.get(0), containerBlock);
        if (defToInline == null) {
            String key = refExpr == null ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        List<Object> refsToInlineList = new ArrayList<PsiElement>();
        Collections.addAll(refsToInlineList, DefUseUtil.getRefs(containerBlock, (PsiVariable)local, (PsiElement)defToInline));
        for (PsiElement innerClassUsage : innerClassUsages) {
            if (refsToInlineList.contains(innerClassUsage)) continue;
            refsToInlineList.add(innerClassUsage);
        }
        if (refsToInlineList.size() == 0) {
            String message = RefactoringBundle.message((String)"variable.is.never.used.before.modification", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        Ref inlineAll = new Ref((Object)true);
        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            int occurrencesCount = refsToInlineList.size();
            if (refExpr != null && occurrencesCount > 1 || EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
                InlineLocalDialog inlineLocalDialog = new InlineLocalDialog(project, (PsiVariable)local, (PsiJavaCodeReferenceElement)refExpr, occurrencesCount);
                if (!inlineLocalDialog.showAndGet()) {
                    WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                    return;
                }
                if (refExpr != null && inlineLocalDialog.isInlineThis()) {
                    refsToInlineList = Collections.singletonList(refExpr);
                    inlineAll.set((Object)false);
                }
            }
        }
        Object[] refsToInline = PsiUtilCore.toPsiElementArray(refsToInlineList);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])refsToInline, attributes, true, null);
        }
        if (refExpr != null && PsiUtil.isAccessedForReading((PsiExpression)refExpr) && ArrayUtil.find((Object[])refsToInline, (Object)refExpr) < 0) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)refExpr);
            LOG.assertTrue(defs.length > 0);
            highlightManager.addOccurrenceHighlights(editor, defs, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)defToInline, PsiTryStatement.class);
        if (tryStatement != null && ExceptionUtil.getThrownExceptions((PsiElement)defToInline).isEmpty()) {
            tryStatement = null;
        }
        PsiFile workingFile = local.getContainingFile();
        for (Object ref : refsToInline) {
            PsiFile otherFile = ref.getContainingFile();
            if (!otherFile.equals(workingFile)) {
                String message = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
                return;
            }
            if (tryStatement == null || PsiTreeUtil.isAncestor((PsiElement)tryStatement, (PsiElement)ref, (boolean)false)) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Unable to inline outside try/catch statement", (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return;
        }
        for (Object ref : refsToInline) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)ref);
            boolean isSameDefinition = true;
            for (PsiElement def : defs) {
                isSameDefinition &= InlineLocalHandler.isSameDefinition(def, defToInline);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor, defs, writeAttributes, true, null);
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{ref}, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        PsiElement writeAccess = InlineLocalHandler.checkRefsInAugmentedAssignmentOrUnaryModified((PsiElement[])refsToInline, (PsiElement)defToInline);
        if (writeAccess != null) {
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{writeAccess}, writeAttributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        final Runnable runnable2 = new Runnable((PsiElement[])refsToInline, project, local, defToInline, inlineAll, editor, highlightManager, attributes, containingClass){
            final /* synthetic */ PsiElement[] val$refsToInline;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiLocalVariable val$local;
            final /* synthetic */ PsiExpression val$defToInline;
            final /* synthetic */ Ref val$inlineAll;
            final /* synthetic */ Editor val$editor;
            final /* synthetic */ HighlightManager val$highlightManager;
            final /* synthetic */ TextAttributes val$attributes;
            final /* synthetic */ PsiClass val$containingClass;
            {
                this.val$refsToInline = psiElementArray;
                this.val$project = project;
                this.val$local = psiLocalVariable;
                this.val$defToInline = psiExpression;
                this.val$inlineAll = ref;
                this.val$editor = editor;
                this.val$highlightManager = highlightManager;
                this.val$attributes = textAttributes;
                this.val$containingClass = psiClass;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String refactoringId = "refactoring.inline.local.variable";
                try {
                    Object[] exprs = new SmartPsiElementPointer[this.val$refsToInline.length];
                    RefactoringEventData beforeData = new RefactoringEventData();
                    beforeData.addElements(this.val$refsToInline);
                    ((RefactoringEventListener)this.val$project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.inline.local.variable", beforeData);
                    SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.val$project);
                    for (int idx = 0; idx < this.val$refsToInline.length; ++idx) {
                        PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)this.val$refsToInline[idx];
                        exprs[idx] = pointerManager.createSmartPsiElementPointer((PsiElement)InlineUtil.inlineVariable((PsiVariable)this.val$local, this.val$defToInline, refElement));
                    }
                    if (((Boolean)this.val$inlineAll.get()).booleanValue()) {
                        if (!InlineLocalHandler.isInliningVariableInitializer(this.val$defToInline)) {
                            this.val$defToInline.getParent().delete();
                        } else {
                            this.val$defToInline.delete();
                        }
                        if (ReferencesSearch.search((PsiElement)this.val$local).findFirst() == null) {
                            QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)this.val$local).invoke(this.val$project, this.val$editor, this.val$local.getContainingFile());
                        }
                    }
                    if (this.val$editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                        this.val$highlightManager.addOccurrenceHighlights(this.val$editor, (PsiElement[])ContainerUtil.convert((Object[])exprs, (Object[])new PsiExpression[this.val$refsToInline.length], (Function)new Function<SmartPsiElementPointer<PsiExpression>, PsiExpression>(){

                            public PsiExpression fun(SmartPsiElementPointer<PsiExpression> pointer) {
                                return (PsiExpression)pointer.getElement();
                            }
                        }), this.val$attributes, true, null);
                        WindowManager.getInstance().getStatusBar(this.val$project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                    }
                    for (SmartPsiElementPointer smartPsiElementPointer : exprs) {
                        InlineUtil.tryToInlineArrayCreationForVarargs((PsiExpression)smartPsiElementPointer.getElement());
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    RefactoringEventData afterData = new RefactoringEventData();
                    afterData.addElement((PsiElement)this.val$containingClass);
                    ((RefactoringEventListener)this.val$project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.inline.local.variable", afterData);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{localName}), null);
    }

    @Nullable
    public static PsiElement checkRefsInAugmentedAssignmentOrUnaryModified(PsiElement[] refsToInline, PsiElement defToInline) {
        for (PsiElement element : refsToInline) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                if (((PsiArrayAccessExpression)parent).getIndexExpression() == element || defToInline instanceof PsiExpression && !(defToInline instanceof PsiNewExpression)) continue;
                element = parent;
                parent = parent.getParent();
            }
            if ((!(parent instanceof PsiAssignmentExpression) || element != ((PsiAssignmentExpression)parent).getLExpression()) && !InlineLocalHandler.isUnaryWriteExpression(parent)) continue;
            return element;
        }
        return null;
    }

    private static boolean isUnaryWriteExpression(PsiElement parent) {
        IElementType tokenType = null;
        if (parent instanceof PsiPrefixExpression) {
            tokenType = ((PsiPrefixExpression)parent).getOperationTokenType();
        }
        if (parent instanceof PsiPostfixExpression) {
            tokenType = ((PsiPostfixExpression)parent).getOperationTokenType();
        }
        return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
    }

    private static boolean isSameDefinition(PsiElement def, PsiExpression defToInline) {
        if (def instanceof PsiLocalVariable) {
            return defToInline.equals(((PsiLocalVariable)def).getInitializer());
        }
        PsiElement parent = def.getParent();
        return parent instanceof PsiAssignmentExpression && defToInline.equals(((PsiAssignmentExpression)parent).getRExpression());
    }

    private static boolean isInliningVariableInitializer(PsiExpression defToInline) {
        return defToInline.getParent() instanceof PsiVariable;
    }

    @Nullable
    static PsiExpression getDefToInline(PsiVariable local, PsiElement refExpr, PsiCodeBlock block) {
        if (refExpr != null) {
            PsiElement def;
            if (refExpr instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refExpr))) {
                def = refExpr;
            } else {
                PsiElement[] defs = DefUseUtil.getDefs(block, local, refExpr);
                if (defs.length == 1) {
                    def = defs[0];
                } else {
                    return null;
                }
            }
            if (def instanceof PsiReferenceExpression && def.getParent() instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)def.getParent();
                if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                    return null;
                }
                PsiExpression rExpr = assignmentExpression.getRExpression();
                if (rExpr != null) {
                    return rExpr;
                }
            }
        }
        return local.getInitializer();
    }
}

