/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureDetectorAction;
import com.intellij.refactoring.changeSignature.ChangeSignatureGestureDetector;
import com.intellij.refactoring.changeSignature.DismissNewSignatureIntentionAction;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignaturePassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public ChangeSignaturePassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, false, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/changeSignature/ChangeSignaturePassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/changeSignature/ChangeSignaturePassFactory", "createHighlightingPass"));
        }
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(file2.getLanguage());
        if (detector == null) {
            return null;
        }
        return new ChangeSignaturePass(file2.getProject(), file2, editor);
    }

    private static class ChangeSignaturePass
    extends TextEditorHighlightingPass {
        @NonNls
        private static final String SIGNATURE_SHOULD_BE_POSSIBLY_CHANGED = "Signature change was detected";
        private final Project myProject;
        private final PsiFile myFile;
        private final Editor myEditor;
        private TextRange myRange;

        public ChangeSignaturePass(Project project, PsiFile file2, Editor editor) {
            super(project, editor.getDocument(), false);
            this.myProject = project;
            this.myFile = file2;
            this.myEditor = editor;
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/refactoring/changeSignature/ChangeSignaturePassFactory$ChangeSignaturePass", "doCollectInformation"));
            }
            this.myRange = null;
            ChangeSignatureGestureDetector detector = ChangeSignatureGestureDetector.getInstance(this.myProject);
            ChangeInfo changeInfo = detector.getInitialChangeInfo(this.myFile);
            if (changeInfo != null) {
                PsiElement element = changeInfo.getMethod();
                int offset = this.myEditor.getCaretModel().getOffset();
                if (element == null || !element.isValid()) {
                    return;
                }
                TextRange elementTextRange = element.getTextRange();
                if (elementTextRange == null || !elementTextRange.contains(offset)) {
                    return;
                }
                TextRange range = ChangeSignaturePass.getHighlightingRange(changeInfo);
                if (range != null && detector.isChangeSignatureAvailable(element)) {
                    this.myRange = range;
                }
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            HighlightInfo info = null;
            if (this.myRange != null) {
                TextAttributes attributes = new TextAttributes(null, null, this.myEditor.getColorsScheme().getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getEffectColor(), null, 0);
                HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.INFORMATION).range(this.myRange);
                builder.textAttributes(attributes);
                builder.descriptionAndTooltip(SIGNATURE_SHOULD_BE_POSSIBLY_CHANGED);
                info = builder.createUnconditionally();
                ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
                options.add(new DismissNewSignatureIntentionAction());
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)new ChangeSignatureDetectorAction(), options, null);
            }
            List<HighlightInfo> infos = info != null ? Collections.singletonList(info) : Collections.emptyList();
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
        }

        @Nullable
        private static TextRange getHighlightingRange(ChangeInfo changeInfo) {
            if (changeInfo == null) {
                return null;
            }
            LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(changeInfo.getLanguage());
            return detector != null ? detector.getHighlightingRange(changeInfo) : null;
        }
    }
}

