/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class LibraryDependentToolWindowManager
extends AbstractProjectComponent {
    private final ToolWindowManagerEx myToolWindowManager;

    protected LibraryDependentToolWindowManager(Project project, ToolWindowManagerEx toolWindowManager) {
        super(project);
        this.myToolWindowManager = toolWindowManager;
    }

    public void projectOpened() {
        ModuleRootAdapter rootListener = new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                if (!LibraryDependentToolWindowManager.this.myProject.isDisposed()) {
                    LibraryDependentToolWindowManager.this.checkToolWindowStatuses(LibraryDependentToolWindowManager.this.myProject);
                }
            }
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable((ModuleRootListener)rootListener){
            final /* synthetic */ ModuleRootListener val$rootListener;
            {
                this.val$rootListener = moduleRootListener;
            }

            @Override
            public void run() {
                if (!LibraryDependentToolWindowManager.this.myProject.isDisposed()) {
                    LibraryDependentToolWindowManager.this.checkToolWindowStatuses(LibraryDependentToolWindowManager.this.myProject);
                    MessageBusConnection connection = LibraryDependentToolWindowManager.this.myProject.getMessageBus().connect((Disposable)LibraryDependentToolWindowManager.this.myProject);
                    connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this.val$rootListener);
                }
            }
        });
    }

    private void checkToolWindowStatuses(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager", "checkToolWindowStatuses"));
        }
        assert (!project.isDisposed());
        DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(){

            @Override
            public void run() {
                for (LibraryDependentToolWindow libraryToolWindow : (LibraryDependentToolWindow[])Extensions.getExtensions((ExtensionPointName)LibraryDependentToolWindow.EXTENSION_POINT_NAME)) {
                    boolean exists;
                    try {
                        exists = libraryToolWindow.getLibrarySearchHelper().isLibraryExists(project);
                    }
                    catch (ProcessCanceledException e) {
                        exists = false;
                        DumbService.getInstance((Project)project).smartInvokeLater((Runnable)this);
                    }
                    if (exists) {
                        LibraryDependentToolWindowManager.this.ensureToolWindowExists(libraryToolWindow);
                        continue;
                    }
                    ToolWindow toolWindow = LibraryDependentToolWindowManager.this.myToolWindowManager.getToolWindow(libraryToolWindow.id);
                    if (toolWindow == null) continue;
                    LibraryDependentToolWindowManager.this.myToolWindowManager.unregisterToolWindow(libraryToolWindow.id);
                }
            }
        });
    }

    private void ensureToolWindowExists(LibraryDependentToolWindow extension) {
        ToolWindow toolWindow = this.myToolWindowManager.getToolWindow(extension.id);
        if (toolWindow == null) {
            this.myToolWindowManager.initToolWindow((ToolWindowEP)extension);
        }
    }
}

