/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.List;

public class AltStateManager
implements AWTEventListener {
    private static final AltStateManager ourInstance = new AltStateManager();
    private final List<AltListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    private AltStateManager() {
    }

    public static AltStateManager getInstance() {
        return ourInstance;
    }

    public void addListener(AltListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(AltListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyEvent.getKeyCode() == 18) {
            if (keyEvent.getID() == 401) {
                this.firePressed();
            } else if (keyEvent.getID() == 402) {
                this.fireReleased();
            }
        }
    }

    private void fireReleased() {
        for (AltListener listener : this.myListeners) {
            listener.altReleased();
        }
    }

    private void firePressed() {
        for (AltListener listener : this.myListeners) {
            listener.altPressed();
        }
    }

    static {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(ourInstance, 8L);
        }
    }

    public static interface AltListener {
        public void altPressed();

        public void altReleased();
    }
}

