/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.encoding.FileEncodingConfigurable;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

class EncodingFileTreeTable
extends AbstractFileTreeTable<Charset> {
    EncodingFileTreeTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/encoding/EncodingFileTreeTable", "<init>"));
        }
        super(project, Charset.class, "Default Encoding", VirtualFileFilter.ALL, false);
        Map<VirtualFile, Charset> mappings = FileEncodingConfigurable.getExistingMappingIncludingDefault(project);
        this.reset(mappings);
        this.getValueColumn().setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                boolean toShow;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Charset t = (Charset)value;
                Object userObject = table.getModel().getValueAt(row, 0);
                VirtualFile file2 = userObject instanceof VirtualFile ? (VirtualFile)userObject : null;
                Pair<Charset, String> check = file2 == null || file2.isDirectory() ? null : EncodingUtil.checkSomeActionEnabled(file2);
                String failReason = check == null ? null : (String)check.second;
                boolean enabled = failReason == null;
                boolean bl = toShow = t != null || failReason != null;
                if (toShow) {
                    Charset existing;
                    Charset charset = existing = check == null ? null : (Charset)check.first;
                    String encodingText = t != null ? t.displayName() : (existing == null ? "N/A" : existing.displayName());
                    this.setText(encodingText + (failReason == null ? "" : " (" + failReason + ")"));
                }
                this.setEnabled(enabled);
                return this;
            }
        });
        this.getValueColumn().setCellEditor(new DefaultCellEditor(new JComboBox()){
            private VirtualFile myVirtualFile;
            {
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    @Override
                    public void setValue(Object value) {
                        EncodingFileTreeTable.this.getTableModel().setValueAt(value, (Object)new DefaultMutableTreeNode(myVirtualFile), -1);
                    }

                    @Override
                    public Object getCellEditorValue() {
                        return EncodingFileTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(myVirtualFile), 1);
                    }
                };
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myVirtualFile = (VirtualFile)table.getModel().getValueAt(row, 0);
                byte[] b = null;
                try {
                    b = this.myVirtualFile == null || this.myVirtualFile.isDirectory() ? null : this.myVirtualFile.contentsToByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                final byte[] bytes = b;
                final Document document = this.myVirtualFile == null ? null : FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
                final ChangeFileEncodingAction cfa = new ChangeFileEncodingAction(true){

                    @Override
                    protected boolean chosen(Document document, Editor editor, @NotNull VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
                        if (virtualFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingFileTreeTable$2$2", "chosen"));
                        }
                        if (charset == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingFileTreeTable$2$2", "chosen"));
                        }
                        EncodingFileTreeTable.this.getValueColumn().getCellEditor().stopCellEditing();
                        EncodingFileTreeTable.this.getTableModel().setValueAt((Object)charset, (Object)new DefaultMutableTreeNode(virtualFile), 1);
                        return true;
                    }
                };
                ComboBoxAction changeAction = new ComboBoxAction(){

                    @NotNull
                    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                        DefaultActionGroup defaultActionGroup = cfa.createActionGroup(myVirtualFile, null, document, bytes, "<Clear>");
                        if (defaultActionGroup == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingFileTreeTable$2$3", "createPopupActionGroup"));
                        }
                        return defaultActionGroup;
                    }
                };
                DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), this.myVirtualFile, SimpleDataContext.getProjectContext(EncodingFileTreeTable.this.getProject()));
                AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)changeAction, null, (String)"unknown", (DataContext)dataContext);
                Presentation presentation = event.getPresentation();
                JComponent comboComponent = changeAction.createCustomComponent(presentation);
                changeAction.update(event);
                presentation.setDescription(null);
                if (this.myVirtualFile == null) {
                    presentation.setEnabled(true);
                }
                this.editorComponent = comboComponent;
                comboComponent.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        AbstractFileTreeTable.press((Container)e.getComponent());
                    }
                });
                Charset charset = (Charset)EncodingFileTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(this.myVirtualFile), 1);
                presentation.setText(charset == null ? "" : charset.displayName());
                comboComponent.setToolTipText(null);
                comboComponent.revalidate();
                return this.editorComponent;
            }
        });
    }

    @Override
    protected boolean isNullObject(Charset value) {
        return value == ChooseFileEncodingAction.NO_ENCODING;
    }

    @Override
    protected boolean isValueEditableForFile(VirtualFile virtualFile) {
        return virtualFile == null || virtualFile.isDirectory() || EncodingUtil.checkSomeActionEnabled(virtualFile) == null;
    }
}

