/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.Convertor;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectsConvertor {
    public static final Convertor<FilePath, VirtualFile> FILEPATH_TO_VIRTUAL = new Convertor<FilePath, VirtualFile>(){

        public VirtualFile convert(FilePath fp) {
            return fp.getVirtualFile();
        }
    };
    public static final Convertor<VirtualFile, FilePath> VIRTUAL_FILEPATH = new Convertor<VirtualFile, FilePath>(){

        public FilePath convert(VirtualFile vf) {
            return VcsUtil.getFilePath((VirtualFile)vf);
        }
    };
    public static final NotNullFunction<Object, Boolean> NOT_NULL = new NotNullFunction<Object, Boolean>(){

        @NotNull
        public Boolean fun(Object o) {
            Boolean bl = o != null;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ObjectsConvertor$3", "fun"));
            }
            return bl;
        }
    };

    public static List<VirtualFile> fp2vf(@NotNull Collection<FilePath> in) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/vcs/ObjectsConvertor", "fp2vf"));
        }
        return ObjectsConvertor.convert(in, FILEPATH_TO_VIRTUAL);
    }

    public static List<FilePath> vf2fp(@NotNull List<VirtualFile> in) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/vcs/ObjectsConvertor", "vf2fp"));
        }
        return ObjectsConvertor.convert(in, VIRTUAL_FILEPATH);
    }

    public static <T, S> List<S> convert(@NotNull Collection<T> in, Convertor<T, S> convertor) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/vcs/ObjectsConvertor", "convert"));
        }
        return ObjectsConvertor.convert(in, convertor, null);
    }

    public static <T, U, S extends U> List<S> convert(@NotNull Collection<T> in, Convertor<T, S> convertor, @Nullable NotNullFunction<U, Boolean> outFilter) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/vcs/ObjectsConvertor", "convert"));
        }
        ArrayList<Object> out = new ArrayList<Object>();
        for (T t : in) {
            Object converted = convertor.convert(t);
            if (outFilter != null && !Boolean.TRUE.equals(outFilter.fun(converted))) continue;
            out.add(converted);
        }
        return out;
    }
}

