/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateSettingsConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final UpdateSettings mySettings = UpdateSettings.getInstance();
    private final boolean myCheckNowEnabled;
    private UpdatesSettingsPanel myPanel;

    public UpdateSettingsConfigurable() {
        this(true);
    }

    public UpdateSettingsConfigurable(boolean checkNowEnabled) {
        this.myCheckNowEnabled = checkNowEnabled;
    }

    public JComponent createComponent() {
        this.myPanel = new UpdatesSettingsPanel(this.myCheckNowEnabled);
        return this.myPanel.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.updates" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable", "getHelpTopic"));
        }
        return "preferences.updates";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public void apply() throws ConfigurationException {
        UpdateCheckerComponent checker;
        if (this.myPanel.myUseSecureConnection.isSelected() && !NetUtils.isSniEnabled()) {
            boolean tooOld = !SystemInfo.isJavaVersionAtLeast((String)"1.7");
            String message = IdeBundle.message((String)(tooOld ? "update.sni.not.available.error" : "update.sni.disabled.error"), (Object[])new Object[0]);
            throw new ConfigurationException(message);
        }
        boolean wasEnabled = this.mySettings.isCheckNeeded();
        this.mySettings.setCheckNeeded(this.myPanel.myCheckForUpdates.isSelected());
        if (wasEnabled != this.mySettings.isCheckNeeded() && (checker = (UpdateCheckerComponent)ApplicationManager.getApplication().getComponent(UpdateCheckerComponent.class)) != null) {
            if (wasEnabled) {
                checker.cancelChecks();
            } else {
                checker.queueNextCheck();
            }
        }
        this.mySettings.setUpdateChannelType(this.myPanel.getSelectedChannelType().getCode());
        this.mySettings.setSecureConnection(this.myPanel.myUseSecureConnection.isSelected());
    }

    public void reset() {
        this.myPanel.myCheckForUpdates.setSelected(this.mySettings.isCheckNeeded());
        this.myPanel.myUseSecureConnection.setSelected(this.mySettings.isSecureConnection());
        this.myPanel.updateLastCheckedLabel();
        this.myPanel.setSelectedChannelType(ChannelStatus.fromCode(this.mySettings.getUpdateChannelType()));
    }

    public boolean isModified() {
        if (this.myPanel == null) {
            return false;
        }
        if (this.mySettings.isCheckNeeded() != this.myPanel.myCheckForUpdates.isSelected() || this.mySettings.isSecureConnection() != this.myPanel.myUseSecureConnection.isSelected()) {
            return true;
        }
        Object channel = this.myPanel.myUpdateChannels.getSelectedItem();
        return channel != null && !channel.equals((Object)ChannelStatus.fromCode(this.mySettings.getUpdateChannelType()));
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static class UpdatesSettingsPanel {
        private final UpdateSettings mySettings;
        private JPanel myPanel;
        private JButton myCheckNow;
        private JCheckBox myCheckForUpdates;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myLastCheckedDate;
        private JComboBox myUpdateChannels;
        private JCheckBox myUseSecureConnection;
        private JPanel mySettingsPanel;
        private JPanel myStatusPanel;

        public UpdatesSettingsPanel(boolean checkNowEnabled) {
            this.$$$setupUI$$$();
            this.mySettings = UpdateSettings.getInstance();
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String majorVersion = appInfo.getMajorVersion();
            String versionNumber = "";
            if (majorVersion != null && majorVersion.trim().length() > 0) {
                String minorVersion = appInfo.getMinorVersion();
                versionNumber = minorVersion != null && minorVersion.trim().length() > 0 ? majorVersion + "." + minorVersion : majorVersion + ".0";
            }
            this.myVersionNumber.setText(appInfo.getVersionName() + " " + versionNumber);
            this.myBuildNumber.setText(appInfo.getBuild().asString());
            LabelTextReplacingUtil.replaceText(this.myPanel);
            if (checkNowEnabled) {
                this.myCheckNow.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)UpdatesSettingsPanel.this.myCheckNow));
                        UpdateSettings settings = new UpdateSettings();
                        settings.loadState(UpdatesSettingsPanel.this.mySettings.getState());
                        settings.setUpdateChannelType(UpdatesSettingsPanel.this.getSelectedChannelType().getCode());
                        settings.setSecureConnection(UpdatesSettingsPanel.this.myUseSecureConnection.isSelected());
                        UpdateChecker.updateAndShowResult(project, settings);
                        UpdatesSettingsPanel.this.updateLastCheckedLabel();
                    }
                });
            } else {
                this.myCheckNow.setVisible(false);
            }
            ChannelStatus current = ChannelStatus.fromCode(this.mySettings.getUpdateChannelType());
            this.myUpdateChannels.setModel(new CollectionComboBoxModel(Arrays.asList(ChannelStatus.values()), (Object)current));
        }

        private void updateLastCheckedLabel() {
            long time = this.mySettings.getLastTimeChecked();
            this.myLastCheckedDate.setText(time == 0L ? IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0]) : DateFormatUtil.formatPrettyDateTime((long)time));
        }

        public ChannelStatus getSelectedChannelType() {
            return (ChannelStatus)((Object)this.myUpdateChannels.getSelectedItem());
        }

        public void setSelectedChannelType(ChannelStatus channelType) {
            this.myUpdateChannels.setSelectedItem((Object)(channelType != null ? channelType : ChannelStatus.RELEASE));
        }

        private void createUIComponents() {
            ArrayList extraStatuses = Lists.newArrayList();
            for (ExternalComponentSource source : ExternalComponentManager.getInstance().getComponentSources()) {
                extraStatuses.addAll(source.getStatuses());
            }
            this.mySettingsPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 3));
            this.mySettingsPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
            this.myCheckForUpdates = new JCheckBox(IdeBundle.message((String)"updates.settings.checkbox", (Object[])new Object[0]));
            this.myUpdateChannels = new JComboBox();
            int row = 0;
            GridConstraints enabledConstraints = new GridConstraints(row, 0, 1, 1, 8, 0, 0, 0, null, null, null);
            GridConstraints controlConstraints = new GridConstraints(row, 1, 1, 1, 8, 1, 2, 0, null, null, null);
            this.mySettingsPanel.add((Component)this.myCheckForUpdates, enabledConstraints);
            this.mySettingsPanel.add((Component)this.myUpdateChannels, controlConstraints);
            this.myStatusPanel = new JPanel((LayoutManager)new GridLayoutManager(extraStatuses.size() + 3, 2));
            row = 0;
            GridConstraints statusLabelConstraints = new GridConstraints(row, 0, 1, 1, 8, 0, 0, 0, null, null, null);
            GridConstraints statusValueConstraints = new GridConstraints(row, 1, 1, 1, 8, 0, 0, 0, null, null, null);
            this.myStatusPanel.add((Component)new JLabel(IdeBundle.message((String)"updates.settings.last.check", (Object[])new Object[0])), statusLabelConstraints);
            this.myLastCheckedDate = new JLabel();
            this.myStatusPanel.add((Component)this.myLastCheckedDate, statusValueConstraints);
            statusLabelConstraints.setRow(++row);
            statusValueConstraints.setRow(row);
            this.myStatusPanel.add((Component)new JLabel(IdeBundle.message((String)"updates.settings.current.version", (Object[])new Object[0])), statusLabelConstraints);
            this.myVersionNumber = new JLabel();
            this.myStatusPanel.add((Component)this.myVersionNumber, statusValueConstraints);
            statusLabelConstraints.setRow(++row);
            statusValueConstraints.setRow(row);
            this.myStatusPanel.add((Component)new JLabel(IdeBundle.message((String)"updates.settings.build.number", (Object[])new Object[0])), statusLabelConstraints);
            this.myBuildNumber = new JLabel();
            this.myStatusPanel.add((Component)this.myBuildNumber, statusValueConstraints);
            for (Pair extra : extraStatuses) {
                statusLabelConstraints.setRow(++row);
                statusValueConstraints.setRow(row);
                this.myStatusPanel.add((Component)new JLabel((String)extra.first), statusLabelConstraints);
                this.myStatusPanel.add((Component)new JLabel((String)extra.second), statusValueConstraints);
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.createUIComponents();
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = this.mySettingsPanel;
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 8, 2, 0, 0, null, null, null));
            JPanel jPanel3 = this.myStatusPanel;
            jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myUseSecureConnection = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.secure"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myCheckNow = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.check.now.button"));
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

