/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesModifiableModel
implements LibraryTableBase.ModifiableModelEx {
    private final Map<Library, ExistingLibraryEditor> myLibrary2EditorMap = ContainerUtil.newIdentityTroveMap();
    private final Set<Library> myRemovedLibraries = ContainerUtil.newIdentityTroveSet();
    private LibraryTable.ModifiableModel myLibrariesModifiableModel;
    private final Project myProject;
    private final LibraryTable myTable;
    private final LibraryEditorListener myLibraryEditorListener;

    public LibrariesModifiableModel(LibraryTable table, Project project, LibraryEditorListener libraryEditorListener) {
        this.myProject = project;
        this.myTable = table;
        this.myLibraryEditorListener = libraryEditorListener;
    }

    public Library createLibrary(String name) {
        return this.createLibrary(name, null);
    }

    public Library createLibrary(String name, @Nullable PersistentLibraryKind type) {
        Library library = this.getLibrariesModifiableModel().createLibrary(name, type);
        BaseLibrariesConfigurable configurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        configurable.createLibraryNode(library);
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel", "removeLibrary"));
        }
        if (this.getLibrariesModifiableModel().getLibraryByName(library.getName()) == null) {
            return;
        }
        this.removeLibraryEditor(library);
        Library existingLibrary = this.myTable.getLibraryByName(library.getName());
        this.getLibrariesModifiableModel().removeLibrary(library);
        if (existingLibrary == library) {
            this.myRemovedLibraries.add(library);
        } else {
            Disposer.dispose((Disposable)library);
        }
    }

    public void commit() {
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator iterator = this.getLibrariesModifiableModel().getLibraryIterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel", "getLibraryIterator"));
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel", "getLibraryByName"));
        }
        return this.getLibrariesModifiableModel().getLibraryByName(name);
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.getLibrariesModifiableModel().getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel", "getLibraries"));
        }
        return libraryArray;
    }

    public boolean isChanged() {
        for (LibraryEditor libraryEditor : this.myLibrary2EditorMap.values()) {
            if (!libraryEditor.hasChanges()) continue;
            return true;
        }
        return this.getLibrariesModifiableModel().isChanged();
    }

    public void deferredCommit() {
        ArrayList<ExistingLibraryEditor> libraryEditors = new ArrayList<ExistingLibraryEditor>(this.myLibrary2EditorMap.values());
        this.myLibrary2EditorMap.clear();
        for (ExistingLibraryEditor libraryEditor : libraryEditors) {
            libraryEditor.commit();
            Disposer.dispose((Disposable)libraryEditor);
        }
        if (!libraryEditors.isEmpty() || !this.myRemovedLibraries.isEmpty() || this.myLibrariesModifiableModel != null && this.myLibrariesModifiableModel.isChanged()) {
            this.getLibrariesModifiableModel().commit();
            this.myLibrariesModifiableModel = null;
        }
        this.myRemovedLibraries.clear();
    }

    public boolean wasLibraryRemoved(Library library) {
        return this.myRemovedLibraries.contains(library);
    }

    public boolean hasLibraryEditor(Library library) {
        return this.myLibrary2EditorMap.containsKey(library);
    }

    public ExistingLibraryEditor getLibraryEditor(Library library) {
        Library source = ((LibraryImpl)library).getSource();
        if (source != null) {
            return this.getLibraryEditor(source);
        }
        ExistingLibraryEditor libraryEditor = this.myLibrary2EditorMap.get(library);
        if (libraryEditor == null) {
            libraryEditor = this.createLibraryEditor(library);
        }
        return libraryEditor;
    }

    private ExistingLibraryEditor createLibraryEditor(Library library) {
        ExistingLibraryEditor libraryEditor = new ExistingLibraryEditor(library, this.myLibraryEditorListener);
        this.myLibrary2EditorMap.put(library, libraryEditor);
        return libraryEditor;
    }

    private void removeLibraryEditor(Library library) {
        ExistingLibraryEditor libraryEditor = this.myLibrary2EditorMap.remove(library);
        if (libraryEditor != null) {
            Disposer.dispose((Disposable)libraryEditor);
        }
    }

    public Library.ModifiableModel getLibraryModifiableModel(Library library) {
        return this.getLibraryEditor(library).getModel();
    }

    private LibraryTable.ModifiableModel getLibrariesModifiableModel() {
        if (this.myLibrariesModifiableModel == null) {
            this.myLibrariesModifiableModel = this.myTable.getModifiableModel();
        }
        return this.myLibrariesModifiableModel;
    }

    public void dispose() {
        if (this.myLibrariesModifiableModel != null) {
            Disposer.dispose((Disposable)this.myLibrariesModifiableModel);
            this.myLibrariesModifiableModel = null;
        }
        this.disposeUncommittedLibraries();
    }

    private void disposeUncommittedLibraries() {
        for (Library library : new ArrayList<Library>(this.myLibrary2EditorMap.keySet())) {
            ExistingLibraryEditor libraryEditor;
            Library existingLibrary = this.myTable.getLibraryByName(library.getName());
            if (existingLibrary != library) {
                Disposer.dispose((Disposable)library);
            }
            if ((libraryEditor = this.myLibrary2EditorMap.get(library)) == null) continue;
            Disposer.dispose((Disposable)libraryEditor);
        }
        this.myLibrary2EditorMap.clear();
    }
}

