/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ManifestFilesInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo");
    private final Map<VirtualFile, ManifestFileConfiguration> myManifestFiles = new HashMap<VirtualFile, ManifestFileConfiguration>();
    private final Map<VirtualFile, ManifestFileConfiguration> myOriginalManifestFiles = new HashMap<VirtualFile, ManifestFileConfiguration>();

    @Nullable
    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType, PackagingElementResolvingContext context) {
        VirtualFile manifestFile = ManifestFileUtil.findManifestFile(element, context, artifactType);
        if (manifestFile == null) {
            return null;
        }
        ManifestFileConfiguration configuration = this.myManifestFiles.get(manifestFile);
        if (configuration == null) {
            configuration = ManifestFileUtil.createManifestFileConfiguration(manifestFile);
            this.myOriginalManifestFiles.put(manifestFile, new ManifestFileConfiguration(configuration));
            this.myManifestFiles.put(manifestFile, configuration);
        }
        return configuration;
    }

    public void saveManifestFiles() {
        for (Map.Entry<VirtualFile, ManifestFileConfiguration> entry : this.myManifestFiles.entrySet()) {
            ManifestFileConfiguration original;
            ManifestFileConfiguration configuration = entry.getValue();
            String path = configuration.getManifestFilePath();
            if (path == null || (original = this.myOriginalManifestFiles.get(entry.getKey())) != null && original.equals((Object)configuration)) continue;
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null) {
                File ioFile = new File(FileUtil.toSystemDependentName((String)path));
                FileUtil.createIfDoesntExist((File)ioFile);
                file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
                if (file2 == null) {
                    LOG.error("cannot create file: " + ioFile);
                }
            }
            ManifestFileUtil.updateManifest(file2, configuration.getMainClass(), configuration.getClasspath(), true);
        }
    }

    public boolean isManifestFilesModified() {
        return !this.myOriginalManifestFiles.equals(this.myManifestFiles);
    }

    public void clear() {
        this.myManifestFiles.clear();
        this.myOriginalManifestFiles.clear();
    }
}

