/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactTypeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ArtifactConfigurable
extends ArtifactConfigurableBase {
    private boolean myIsInUpdateName;

    public ArtifactConfigurable(Artifact originalArtifact, ArtifactsStructureConfigurableContextImpl artifactsStructureContext, Runnable updateTree) {
        super(originalArtifact, artifactsStructureContext, updateTree, true);
    }

    public void setDisplayName(String name) {
        String oldName = this.getArtifact().getName();
        if (name != null && !name.equals(oldName) && !this.myIsInUpdateName) {
            this.myArtifactsStructureContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact).setName(name);
            this.getEditor().updateOutputPath(oldName, name);
        }
    }

    public void updateName() {
        this.myIsInUpdateName = true;
        try {
            super.updateName();
        }
        finally {
            this.myIsInUpdateName = false;
        }
    }

    public JComponent createOptionsPanel() {
        return this.getEditor().createMainComponent();
    }

    protected JComponent createTopRightComponent() {
        final ComboBox artifactTypeBox = new ComboBox();
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            artifactTypeBox.addItem((Object)type);
        }
        artifactTypeBox.setRenderer((ListCellRenderer)((Object)new ArtifactTypeCellRenderer(artifactTypeBox.getRenderer())));
        artifactTypeBox.setSelectedItem((Object)this.getArtifact().getArtifactType());
        artifactTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArtifactType selected = (ArtifactType)artifactTypeBox.getSelectedItem();
                if (selected != null && !Comparing.equal((Object)selected, (Object)ArtifactConfigurable.this.getArtifact().getArtifactType())) {
                    ArtifactConfigurable.this.getEditor().setArtifactType(selected);
                }
            }
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(new JLabel("Type: "));
        panel.add((Component)artifactTypeBox);
        return panel;
    }

    public boolean isModified() {
        return this.getEditor().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getEditor().apply();
    }

    public void reset() {
    }

    public String getHelpTopic() {
        return this.getEditor().getHelpTopic();
    }

    private ArtifactEditorImpl getEditor() {
        return this.myArtifactsStructureContext.getOrCreateEditor(this.myOriginalArtifact);
    }
}

