/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class GeneralProjectSettingsElement
extends ProjectStructureElement {
    public GeneralProjectSettingsElement(@NotNull StructureConfigurableContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "<init>"));
        }
        super(context);
    }

    @Override
    public String getPresentableName() {
        return "Project";
    }

    @Override
    public String getTypeName() {
        return "Project";
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        ProjectSdksModel model;
        Sdk sdk;
        Project project = this.myContext.getProject();
        if (this.containsModuleWithInheritedSdk() && (sdk = (model = ProjectStructureConfigurable.getInstance(project).getProjectJdksModel()).getProjectSdk()) == null) {
            PlaceInProjectStructureBase place = new PlaceInProjectStructureBase(project, ProjectStructureConfigurable.getInstance(project).createProjectConfigurablePlace(), this);
            problemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.project.jdk.problem.message", (Object[])new Object[0]), null, ProjectStructureProblemType.error("project-sdk-not-defined"), place, null);
        }
        Graph graph = ModuleCompilerUtil.createModuleSourceDependenciesGraph((RootModelProvider)this.myContext.getModulesConfigurator());
        Collection chunks = GraphAlgorithms.getInstance().computeStronglyConnectedComponents(graph);
        List<Chunk<ModuleSourceSet>> sourceSetCycles = GeneralProjectSettingsElement.removeSingleElementChunks(this.removeDummyNodes(GeneralProjectSettingsElement.filterDuplicates(GeneralProjectSettingsElement.removeSingleElementChunks(chunks))));
        ArrayList<String> cycles = new ArrayList<String>();
        for (Chunk<ModuleSourceSet> chunk : sourceSetCycles) {
            Set sourceSets = chunk.getNodes();
            ArrayList<String> names = new ArrayList<String>();
            for (ModuleSourceSet sourceSet : sourceSets) {
                String name = sourceSet.getDisplayName();
                names.add(names.isEmpty() ? name : StringUtil.decapitalize((String)name));
            }
            cycles.add(StringUtil.join(names, (String)", "));
        }
        if (!cycles.isEmpty()) {
            String description;
            String message;
            PlaceInProjectStructureBase place = new PlaceInProjectStructureBase(project, ProjectStructureConfigurable.getInstance(project).createModulesPlace(), this);
            if (cycles.size() > 1) {
                message = "Circular dependencies";
                String br = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
                StringBuilder cyclesString = new StringBuilder();
                for (int i = 0; i < cycles.size(); ++i) {
                    cyclesString.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;").append(i + 1).append(". ").append((String)cycles.get(i));
                }
                description = ProjectBundle.message((String)"module.circular.dependency.warning.description", (Object[])new Object[]{cyclesString});
            } else {
                message = ProjectBundle.message((String)"module.circular.dependency.warning.short", (Object[])new Object[]{StringUtil.decapitalize((String)((String)cycles.get(0)))});
                description = null;
            }
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, place, ProjectStructureProblemType.warning("module-circular-dependency"), Collections.emptyList()));
        }
    }

    private List<Chunk<ModuleSourceSet>> removeDummyNodes(List<Chunk<ModuleSourceSet>> chunks) {
        ArrayList<Chunk<ModuleSourceSet>> result2 = new ArrayList<Chunk<ModuleSourceSet>>(chunks.size());
        for (Chunk<ModuleSourceSet> chunk : chunks) {
            LinkedHashSet<ModuleSourceSet> nodes = new LinkedHashSet<ModuleSourceSet>();
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (this.isDummy(sourceSet)) continue;
                nodes.add(sourceSet);
            }
            result2.add((Chunk<ModuleSourceSet>)new Chunk(nodes));
        }
        return result2;
    }

    private boolean isDummy(ModuleSourceSet set) {
        JavaSourceRootType type = set.getType() == ModuleSourceSet.Type.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(set.getModule());
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (entry.getSourceFolders((JpsModuleSourceRootType)type).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean containsModuleWithInheritedSdk() {
        for (Module module : this.myContext.getModules()) {
            ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(module);
            if (!rootModel.isSdkInherited()) continue;
            return true;
        }
        return false;
    }

    private static List<Chunk<ModuleSourceSet>> removeSingleElementChunks(Collection<Chunk<ModuleSourceSet>> chunks) {
        return ContainerUtil.filter(chunks, (Condition)new Condition<Chunk<ModuleSourceSet>>(){

            public boolean value(Chunk<ModuleSourceSet> chunk) {
                return chunk.getNodes().size() > 1;
            }
        });
    }

    @NotNull
    private static List<Chunk<ModuleSourceSet>> filterDuplicates(@NotNull Collection<Chunk<ModuleSourceSet>> sourceSetCycles) {
        if (sourceSetCycles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSetCycles", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "filterDuplicates"));
        }
        final ArrayList<Set> productionCycles = new ArrayList<Set>();
        for (Chunk<ModuleSourceSet> cycle : sourceSetCycles) {
            ModuleSourceSet.Type type = GeneralProjectSettingsElement.getCommonType(cycle);
            if (type != ModuleSourceSet.Type.PRODUCTION) continue;
            productionCycles.add(ModuleSourceSet.getModules((Collection)cycle.getNodes()));
        }
        List list = ContainerUtil.filter(sourceSetCycles, (Condition)new Condition<Chunk<ModuleSourceSet>>(){

            public boolean value(Chunk<ModuleSourceSet> chunk) {
                if (GeneralProjectSettingsElement.getCommonType((Chunk<ModuleSourceSet>)chunk) != ModuleSourceSet.Type.TEST) {
                    return true;
                }
                for (Set productionCycle : productionCycles) {
                    if (!productionCycle.containsAll(ModuleSourceSet.getModules((Collection)chunk.getNodes()))) continue;
                    return false;
                }
                return true;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "filterDuplicates"));
        }
        return list;
    }

    @Nullable
    private static ModuleSourceSet.Type getCommonType(@NotNull Chunk<ModuleSourceSet> cycle) {
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "getCommonType"));
        }
        ModuleSourceSet.Type type = null;
        for (ModuleSourceSet set : cycle.getNodes()) {
            if (type == null) {
                type = set.getType();
                continue;
            }
            if (type == set.getType()) continue;
            return null;
        }
        return type;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return "project:general";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GeneralProjectSettingsElement;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

