/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableVisitor {
    public static final ConfigurableVisitor ALL = new ConfigurableVisitor(){

        @Override
        protected boolean accept(Configurable configurable) {
            return true;
        }
    };

    protected abstract boolean accept(Configurable var1);

    public final Configurable find(ConfigurableGroup ... groups) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/ex/ConfigurableVisitor", "find"));
        }
        for (ConfigurableGroup group : groups) {
            Configurable result2 = this.find(group.getConfigurables());
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public final Configurable find(Configurable ... configurables) {
        if (configurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/openapi/options/ex/ConfigurableVisitor", "find"));
        }
        for (Configurable configurable : configurables) {
            if (!this.accept(configurable)) continue;
            return configurable;
        }
        for (Configurable configurable : configurables) {
            Configurable.Composite composite;
            Configurable result2;
            if (!(configurable instanceof Configurable.Composite) || (result2 = this.find((composite = (Configurable.Composite)configurable).getConfigurables())) == null) continue;
            return result2;
        }
        return null;
    }

    public final List<Configurable> findAll(ConfigurableGroup ... groups) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/ex/ConfigurableVisitor", "findAll"));
        }
        ArrayList<Configurable> list = new ArrayList<Configurable>();
        for (ConfigurableGroup group : groups) {
            this.add(list, group.getConfigurables());
        }
        return list;
    }

    public final List<Configurable> findAll(Configurable ... configurables) {
        if (configurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/openapi/options/ex/ConfigurableVisitor", "findAll"));
        }
        ArrayList<Configurable> list = new ArrayList<Configurable>();
        this.add(list, configurables);
        return list;
    }

    private void add(List<Configurable> list, Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            if (this.accept(configurable)) {
                list.add(configurable);
            }
            if (!(configurable instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)configurable;
            this.add(list, composite.getConfigurables());
        }
    }

    public static final class ByType
    extends ConfigurableVisitor {
        private final Class<? extends Configurable> myType;

        public ByType(@NotNull Class<? extends Configurable> type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/options/ex/ConfigurableVisitor$ByType", "<init>"));
            }
            this.myType = type;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return ConfigurableWrapper.cast(this.myType, (UnnamedConfigurable)configurable) != null;
        }
    }

    public static final class ByName
    extends ConfigurableVisitor {
        private final String myName;

        public ByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/ex/ConfigurableVisitor$ByName", "<init>"));
            }
            this.myName = name;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return this.myName.equals(configurable.getDisplayName());
        }
    }

    public static final class ByID
    extends ConfigurableVisitor {
        private final String myID;

        public ByID(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ex/ConfigurableVisitor$ByID", "<init>"));
            }
            this.myID = id;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return this.myID.equals(ByID.getID(configurable));
        }

        public static String getID(Configurable configurable) {
            return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getId() : configurable.getClass().getName();
        }
    }
}

