/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.SummaryStatistics;
import gnu.trove.TLongArrayList;

class DelayMeter {
    private final TLongArrayList myStartTimes = new TLongArrayList();
    private SummaryStatistics myStats = new SummaryStatistics();

    DelayMeter() {
    }

    void registerStart() {
        this.myStartTimes.add(System.nanoTime());
    }

    void registerFinish() {
        if (!this.myStartTimes.isEmpty()) {
            long now = System.nanoTime();
            for (int i = 0; i < this.myStartTimes.size(); ++i) {
                long elapsed = now - this.myStartTimes.get(i);
                this.myStats.accept(elapsed);
            }
            this.myStartTimes.clear();
        }
    }

    void reset() {
        this.myStats = new SummaryStatistics();
    }

    double getMin() {
        return this.myStats.getMin();
    }

    double getMax() {
        return this.myStats.getMax();
    }

    double getMean() {
        return this.myStats.getMean();
    }

    double getStandardDeviation() {
        return this.myStats.getStandardDeviation();
    }

    public String stat() {
        return this.myStats.stat();
    }
}

