/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;

public class TextEndAction
extends TextComponentEditorAction {
    public TextEndAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void execute(Editor editor, DataContext dataContext) {
            IdeDocumentHistory instance;
            editor.getCaretModel().removeSecondaryCarets();
            int offset = editor.getDocument().getTextLength();
            if (editor instanceof EditorImpl && ((EditorImpl)editor).myUseNewRendering) {
                editor.getCaretModel().moveToLogicalPosition(editor.offsetToLogicalPosition(offset).leanForward(true));
            } else {
                editor.getCaretModel().moveToOffset(offset);
            }
            editor.getSelectionModel().removeSelection();
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project != null && (instance = IdeDocumentHistory.getInstance(project)) != null) {
                instance.includeCurrentCommandAsNavigation();
            }
        }
    }
}

