/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.configurable;

import com.intellij.ide.BrowserUtil;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.configurable.SendPeriod;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class StatisticsConfigurationComponent {
    private JPanel myMainPanel;
    private JLabel myTitle;
    private JCheckBox myAllowToSendUsagesCheckBox;
    private JRadioButton myDailyRadioButton;
    private JRadioButton myMonthlyRadioButton;
    private JRadioButton myWeeklyRadioButton;
    private JLabel myLabel;
    private JPanel myRadioButtonPanel;
    private HyperlinkLabel myHyperLink;

    public StatisticsConfigurationComponent() {
        Map<String, String> overrides;
        this.$$$setupUI$$$();
        String product = ApplicationNamesInfo.getInstance().getFullProductName();
        String company = ApplicationInfo.getInstance().getCompanyName();
        this.myTitle.setText(StatisticsBundle.message("stats.title", product, company));
        this.myLabel.setText(StatisticsBundle.message("stats.config.details", company));
        String linkUrl = null;
        String linkBeforeText = null;
        String linkText = null;
        String linkAfterText = null;
        this.myAllowToSendUsagesCheckBox.setText(StatisticsBundle.message("stats.config.allow.send.stats.text", company));
        this.myAllowToSendUsagesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsConfigurationComponent.this.setRadioButtonsEnabled();
            }
        });
        StatisticsService service = StatisticsUploadAssistant.getStatisticsService();
        if (service != null && (overrides = service.getStatisticsConfigurationLabels()) != null) {
            String s = overrides.get("title");
            if (s != null) {
                this.myTitle.setText(s);
            }
            if ((s = overrides.get("details")) != null) {
                this.myLabel.setText(s);
            }
            if ((s = overrides.get("allow-checkbox")) != null) {
                this.myAllowToSendUsagesCheckBox.setText(s);
            }
            linkUrl = overrides.get("linkUrl");
            linkBeforeText = overrides.get("linkBeforeText");
            linkText = overrides.get("linkText");
            linkAfterText = overrides.get("linkAfterText");
        }
        this.myTitle.setText(this.myTitle.getText().replace("%company%", company));
        this.myLabel.setText(this.myLabel.getText().replace("%company%", company));
        this.myAllowToSendUsagesCheckBox.setText(this.myAllowToSendUsagesCheckBox.getText().replace("%company%", company));
        if (linkUrl == null) {
            this.myHyperLink.setVisible(false);
        } else {
            this.myHyperLink.setHyperlinkText(StringUtil.notNullize(linkBeforeText), StringUtil.notNullize(linkText), StringUtil.notNullize(linkAfterText));
            final String url = linkUrl;
            this.myHyperLink.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtil.browse((String)url);
                    }
                }
            });
        }
        this.myRadioButtonPanel.setVisible(false);
    }

    private void setRadioButtonsEnabled() {
        boolean enabled = this.myAllowToSendUsagesCheckBox.isSelected();
        this.myWeeklyRadioButton.setEnabled(enabled);
        this.myMonthlyRadioButton.setEnabled(enabled);
        this.myDailyRadioButton.setEnabled(enabled);
    }

    public JPanel getJComponent() {
        return this.myMainPanel;
    }

    public boolean isAllowed() {
        return this.myAllowToSendUsagesCheckBox.isSelected();
    }

    public void reset() {
        UsageStatisticsPersistenceComponent persistenceComponent = UsageStatisticsPersistenceComponent.getInstance();
        this.myAllowToSendUsagesCheckBox.setSelected(persistenceComponent.isAllowed());
        this.setRadioButtonsEnabled();
        SendPeriod period = persistenceComponent.getPeriod();
        switch (period) {
            case DAILY: {
                this.myDailyRadioButton.setSelected(true);
                break;
            }
            case MONTHLY: {
                this.myMonthlyRadioButton.setSelected(true);
                break;
            }
            default: {
                this.myWeeklyRadioButton.setSelected(true);
            }
        }
    }

    public SendPeriod getPeriod() {
        if (this.myDailyRadioButton.isSelected()) {
            return SendPeriod.DAILY;
        }
        if (this.myMonthlyRadioButton.isSelected()) {
            return SendPeriod.MONTHLY;
        }
        return SendPeriod.WEEKLY;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel;
        JLabel jLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAllowToSendUsagesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jCheckBox.setSelected(true);
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRadioButtonPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 10, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myDailyRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Daily");
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWeeklyRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Weekly");
        jRadioButton2.setSelected(true);
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMonthlyRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Monthly");
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLabel = jLabel2 = new JLabel();
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTitle = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myHyperLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

