/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.ide.SystemHealthMonitor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.analytics.LastSeenExceptions;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyticsUploader {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication() == null;
    private static final boolean DEBUG = !UNIT_TEST_MODE && ApplicationManager.getApplication().isInternal();
    @NonNls
    private static final String ANALYTICS_URL = "https://ssl.google-analytics.com/collect";
    @NonNls
    private static final String ANALYTICS_ID = DEBUG ? "UA-44790371-1" : "UA-19996407-3";
    @NonNls
    private static final String ANALYTICS_APP = "Android Studio";
    private static final String INSTALLATION_ID = UNIT_TEST_MODE ? "unit-test" : UpdateChecker.getInstallationUID(PropertiesComponent.getInstance());
    private static final int MAX_DESCRIPTION_SIZE = 150;
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(ArrayIndexOutOfBoundsException.class, ClassCastException.class, ClassNotFoundException.class);
    private static final String PROTOCOL_VERSION = "v";
    private static final String TRACKING_ID = "tid";
    private static final String APPLICATION_NAME = "an";
    private static final String APPLICATION_VERSION = "av";
    private static final String CLIENT_ID = "cid";
    private static final String HIT_TYPE = "t";
    private static final String HIT_TYPE_EVENT = "event";
    private static final String EVENT_CATEGORY = "ec";
    private static final String EVENT_ACTION = "ea";
    private static final String EVENT_LABEL = "el";
    private static final String EVENT_VALUE = "ev";
    private static final String HIT_TYPE_EXCEPTION = "exception";
    private static final String EXCEPTION_DESCRIPTION = "exd";
    private static final String EXCEPTION_FATAL = "exf";
    private static final String CD_OS_NAME = "cd1";
    private static final String CD_OS_VERSION = "cd2";
    private static final String CD_JAVA_RUNTIME_VERSION = "cd3";
    private static final String CD_UPDATE_CHANNEL = "cd4";
    private static final String CD_LOCALE = "cd5";
    private static final String CM_ACTIVITY_COUNT = "cm1";
    private static final List<BasicNameValuePair> analyticsBaseData = ImmutableList.of((Object)new BasicNameValuePair("v", "1"), (Object)new BasicNameValuePair("tid", ANALYTICS_ID), (Object)new BasicNameValuePair("an", "Android Studio"), (Object)new BasicNameValuePair("av", UNIT_TEST_MODE ? "unit-test" : ApplicationInfo.getInstance().getStrictVersion()), (Object)new BasicNameValuePair("cid", INSTALLATION_ID), (Object)new BasicNameValuePair("cd1", SystemInfo.OS_NAME), (Object)new BasicNameValuePair("cd2", SystemInfo.OS_VERSION), (Object)new BasicNameValuePair("cd3", SystemInfo.JAVA_RUNTIME_VERSION), (Object)new BasicNameValuePair("cd5", AnalyticsUploader.getLanguage()));
    public static final String CATEGORY_STUDIO_EXCEPTION = "excstudio";
    private static final LastSeenExceptions ourLastSeenExceptions = new LastSeenExceptions(3);

    public static String getLanguage() {
        Locale locale = Locale.getDefault();
        return locale == null ? "unknown" : locale.toString();
    }

    public static boolean trackingEnabled() {
        return DEBUG || StatisticsUploadAssistant.isSendAllowed();
    }

    public static void trackEvent(@NotNull String eventCategory, @NotNull String eventAction, @Nullable String eventLabel, @Nullable Integer eventValue) {
        if (eventCategory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventCategory", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "trackEvent"));
        }
        if (eventAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventAction", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "trackEvent"));
        }
        ArrayList postData = Lists.newArrayList(analyticsBaseData);
        postData.add(new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EVENT));
        postData.add(new BasicNameValuePair(EVENT_CATEGORY, eventCategory));
        postData.add(new BasicNameValuePair(EVENT_ACTION, eventAction));
        if (!StringUtil.isEmpty((String)eventLabel)) {
            postData.add(new BasicNameValuePair(EVENT_LABEL, eventLabel));
        }
        if (eventValue != null) {
            if (eventValue < 0 && DEBUG) {
                System.err.println("Attempting to send negative event value to the analytics server");
            } else {
                postData.add(new BasicNameValuePair(EVENT_VALUE, eventValue.toString()));
            }
        }
        AnalyticsUploader.postToAnalytics(postData);
    }

    public static void trackCrashes(@NotNull Iterable<String> descriptions) {
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "trackCrashes"));
        }
        long crashCount = 0L;
        for (String description : descriptions) {
            AnalyticsUploader.trackCrash(description);
            ++crashCount;
        }
        AnalyticsUploader.trackExceptionsAndActivity(0L, 0L, 0L, 0L, crashCount);
    }

    private static void trackCrash(@NotNull String description) {
        block4: {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "trackCrash"));
            }
            if (!AnalyticsUploader.trackingEnabled()) {
                return;
            }
            try {
                AnalyticsUploader.postToAnalytics((List<BasicNameValuePair>)ImmutableList.of((Object)new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EXCEPTION), (Object)new BasicNameValuePair(EXCEPTION_DESCRIPTION, "StudioCrash: " + description), (Object)new BasicNameValuePair(EXCEPTION_FATAL, "1")));
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block4;
                System.err.println("Unexpected error while reporting a crash: " + throwable);
            }
        }
    }

    public static void trackException(@NotNull Throwable t, boolean fatal) {
        block9: {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", HIT_TYPE, "com/intellij/internal/statistic/analytics/AnalyticsUploader", "trackException"));
            }
            if (!AnalyticsUploader.trackingEnabled()) {
                return;
            }
            try {
                t = AnalyticsUploader.getRootCause(t);
                if (t instanceof Logger.EmptyThrowable) {
                    return;
                }
                SystemHealthMonitor.incrementAndSaveExceptionCount();
                PluginId pluginId = IdeErrorsDialog.findPluginId(t);
                if (pluginId != null) {
                    if (PluginManager.getPlugin(pluginId).isBundled()) {
                        SystemHealthMonitor.incrementAndSaveBundledPluginsExceptionCount();
                    } else {
                        SystemHealthMonitor.incrementAndSaveNonBundledPluginsExceptionCount();
                    }
                }
                String description = AnalyticsUploader.getDescription(t);
                AnalyticsUploader.postToAnalytics((List<BasicNameValuePair>)ImmutableList.of((Object)new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EXCEPTION), (Object)new BasicNameValuePair(EXCEPTION_DESCRIPTION, description), (Object)new BasicNameValuePair(EXCEPTION_FATAL, fatal ? "1" : "0")));
                if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(t.getClass())) {
                    AnalyticsUploader.trackEvent("Throwable.detailMessage", t.getClass().getSimpleName(), t.getMessage(), null);
                }
                ourLastSeenExceptions.add(description);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block9;
                System.err.println("Unexpected error while reporting a crash: " + throwable);
            }
        }
    }

    @NotNull
    public static String getLastExceptionDescription() {
        String string = ourLastSeenExceptions.getDescriptions();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getLastExceptionDescription"));
        }
        return string;
    }

    public static void trackExceptionsAndActivity(long activityCount, long exceptionCount, long bundledPluginExceptionCount, long nonBundledPluginExceptionCount, long fatalExceptionCount) {
        block4: {
            if (!AnalyticsUploader.trackingEnabled()) {
                return;
            }
            try {
                AnalyticsUploader.postToAnalytics((List<BasicNameValuePair>)ImmutableList.of((Object)new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EVENT), (Object)new BasicNameValuePair(EVENT_CATEGORY, "ActivityTracker"), (Object)new BasicNameValuePair(EVENT_ACTION, "Hit"), (Object)new BasicNameValuePair(EVENT_VALUE, Long.toString(activityCount)), (Object)new BasicNameValuePair(CM_ACTIVITY_COUNT, Long.toString(activityCount))));
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block4;
                System.err.println("Unexpected error while reporting a activity: " + throwable);
            }
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            AnalyticsUploader.postToGoogleLogs(CATEGORY_STUDIO_EXCEPTION, (Map<String, String>)ImmutableMap.of((Object)"activity", (Object)Long.toString(activityCount), (Object)"exc", (Object)Long.toString(exceptionCount), (Object)"exb", (Object)Long.toString(bundledPluginExceptionCount), (Object)"exp", (Object)Long.toString(nonBundledPluginExceptionCount), (Object)EXCEPTION_FATAL, (Object)Long.toString(fatalExceptionCount)));
        }
    }

    public static void postToGoogleLogs(final @NotNull String categoryId, final @NotNull Map<String, String> parameters) {
        if (categoryId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryId", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "postToGoogleLogs"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "postToGoogleLogs"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        URL url = AnalyticsUploader.getPingUrl(categoryId, ApplicationInfo.getInstance().getStrictVersion(), INSTALLATION_ID, parameters);
                        AnalyticsUploader.postToGoogleLogs(url);
                    }
                    catch (Throwable t) {
                        if (!DEBUG) break block2;
                        System.err.println("Unexpected error while uploading exception metrics: " + t);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postToGoogleLogs(@NotNull URL url) throws IOException {
        int responseCode;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "postToGoogleLogs"));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            responseCode = conn.getResponseCode();
        }
        catch (UnknownHostException e) {
            if (DEBUG) {
                System.err.println("Unexpected exception while sending exception counts: " + e);
            }
            return;
        }
        finally {
            conn.disconnect();
        }
        if (DEBUG && responseCode != 404) {
            System.err.println("Ping did not return a 404");
        }
    }

    private static void postToAnalytics(final @NotNull List<BasicNameValuePair> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "postToAnalytics"));
        }
        String channel = UNIT_TEST_MODE ? "unit-test" : ChannelStatus.fromCode(UpdateSettings.getInstance().getUpdateChannelType()).getDisplayName();
        final List<BasicNameValuePair> runtimeData = Collections.singletonList(new BasicNameValuePair(CD_UPDATE_CHANNEL, channel));
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost request = new HttpPost(AnalyticsUploader.ANALYTICS_URL);
                try {
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(Iterables.concat((Iterable)analyticsBaseData, (Iterable)runtimeData, (Iterable)parameters)));
                    CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                    StatusLine status = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    if (status.getStatusCode() >= 300 && DEBUG) {
                        System.err.println("Error reporting to Analytics, return code: " + status.getStatusCode());
                    }
                }
                catch (IOException e) {
                    if (DEBUG) {
                        System.err.println("Error reporting to Analytics: " + e.getMessage());
                    }
                }
                finally {
                    HttpClientUtils.closeQuietly((HttpClient)client);
                }
            }
        });
    }

    @VisibleForTesting
    @NotNull
    public static String getDescription(@NotNull Throwable t) {
        int i;
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", HIT_TYPE, "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getDescription"));
        }
        StringBuilder sb = new StringBuilder(150);
        String simpleName = t.getClass().getSimpleName().replace("Exception", "Ex").replace("Error", "Er");
        sb.append(simpleName);
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        if (stackTraceElements.length > 0) {
            sb.append(" @ ");
        }
        boolean androidPlugin = false;
        String lastFileName = "";
        for (i = 0; i < stackTraceElements.length && sb.length() < 150; ++i) {
            String fileName;
            StackTraceElement el = stackTraceElements[i];
            String className = el.getClassName();
            if (className != null && (className.startsWith("java.") || className.startsWith("javax."))) {
                sb.append('.');
                continue;
            }
            if (i != 0) {
                sb.append(" < ");
            }
            if (!StringUtil.equals((CharSequence)(fileName = AnalyticsUploader.getBaseName(el.getFileName())), (CharSequence)lastFileName)) {
                sb.append(fileName);
                lastFileName = fileName;
            }
            sb.append(':');
            sb.append(el.getLineNumber());
            if (androidPlugin) continue;
            androidPlugin = AnalyticsUploader.fromAndroidPlugin(el);
        }
        String desc = sb.toString();
        if (!androidPlugin && i < stackTraceElements.length) {
            while (i < stackTraceElements.length) {
                StackTraceElement el = stackTraceElements[i];
                if (AnalyticsUploader.fromAndroidPlugin(el)) {
                    String android = "... < " + AnalyticsUploader.getBaseName(el.getFileName()) + ":" + el.getLineNumber();
                    if (desc.length() + android.length() > 150) {
                        desc = desc.substring(0, 150 - android.length());
                    }
                    desc = desc + android;
                    break;
                }
                ++i;
            }
        }
        if (desc.length() > 150) {
            desc = desc.substring(0, 149) + ">";
        }
        while (desc.getBytes(Charsets.UTF_8).length > 150) {
            desc = desc.substring(0, desc.length() - 1);
        }
        String string = desc;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getDescription"));
        }
        return string;
    }

    private static boolean fromAndroidPlugin(StackTraceElement el) {
        return el.getClassName().contains("android");
    }

    private static Throwable getRootCause(Throwable e) {
        int depth = 0;
        while (depth++ < 20) {
            if (e.getCause() == null) {
                return e;
            }
            e = e.getCause();
        }
        return e;
    }

    private static String getBaseName(@Nullable String fileName) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            return "U";
        }
        int extension = fileName.indexOf(46);
        if (extension > 0) {
            return fileName.substring(0, extension);
        }
        return fileName;
    }

    @VisibleForTesting
    @NotNull
    public static URL getPingUrl(@NotNull String categoryId, @NotNull String version, @NotNull String installationId, @NotNull Map<String, String> parameters) throws MalformedURLException, UnsupportedEncodingException {
        if (categoryId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryId", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getPingUrl"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getPingUrl"));
        }
        if (installationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installationId", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getPingUrl"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getPingUrl"));
        }
        String urlPrefix = String.format(Locale.US, "https://tools.google.com/service/update?as=androidsdk_%1$s&version=%2$s&uid=%3$s", categoryId, URLEncoder.encode(version, Charsets.UTF_8.name()), URLEncoder.encode(installationId, Charsets.UTF_8.name()));
        StringBuilder sb = new StringBuilder(urlPrefix);
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            sb.append('&');
            sb.append(URLEncoder.encode(key, Charsets.UTF_8.name()));
            sb.append('=');
            sb.append(URLEncoder.encode(value, Charsets.UTF_8.name()));
        }
        URL uRL = new URL(sb.toString());
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/analytics/AnalyticsUploader", "getPingUrl"));
        }
        return uRL;
    }
}

