/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeJavaClassChooserDialog
extends AbstractTreeClassChooserDialog<PsiClass>
implements TreeClassChooser {
    public TreeJavaClassChooserDialog(String title, Project project) {
        super(title, project, PsiClass.class);
    }

    public TreeJavaClassChooserDialog(String title, Project project, @Nullable PsiClass initialClass) {
        super(title, project, PsiClass.class, initialClass);
    }

    public TreeJavaClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, ClassFilter classFilter, @Nullable PsiClass initialClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/TreeJavaClassChooserDialog", "<init>"));
        }
        super(title, project, scope, PsiClass.class, TreeJavaClassChooserDialog.createFilter(classFilter), initialClass);
    }

    public TreeJavaClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, @Nullable ClassFilter classFilter, PsiClass baseClass, @Nullable PsiClass initialClass, boolean isShowMembers) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/TreeJavaClassChooserDialog", "<init>"));
        }
        super(title, project, scope, PsiClass.class, TreeJavaClassChooserDialog.createFilter(classFilter), baseClass, initialClass, isShowMembers, true);
    }

    public static TreeJavaClassChooserDialog withInnerClasses(String title, @NotNull Project project, GlobalSearchScope scope, ClassFilter classFilter, @Nullable PsiClass initialClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/TreeJavaClassChooserDialog", "withInnerClasses"));
        }
        return new TreeJavaClassChooserDialog(title, project, scope, classFilter, null, initialClass, true);
    }

    @Nullable
    private static TreeChooser.Filter<PsiClass> createFilter(final @Nullable ClassFilter classFilter) {
        if (classFilter == null) {
            return null;
        }
        return new TreeChooser.Filter<PsiClass>(){

            public boolean isAccepted(final PsiClass element) {
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return classFilter.isAccepted(element);
                    }
                });
            }
        };
    }

    @Override
    @Nullable
    protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ClassTreeNode)) {
            return null;
        }
        ClassTreeNode descriptor = (ClassTreeNode)((Object)userObject);
        return descriptor.getPsiClass();
    }

    @Override
    @NotNull
    protected List<PsiClass> getClassesByName(String name, boolean checkBoxState, String pattern, GlobalSearchScope searchScope) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.getProject());
        Object[] classes = cache.getClassesByName(name, checkBoxState ? searchScope : GlobalSearchScope.projectScope((Project)this.getProject()).intersectWith(searchScope));
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])classes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeJavaClassChooserDialog", "getClassesByName"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected AbstractTreeClassChooserDialog.BaseClassInheritorsProvider<PsiClass> getInheritorsProvider(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/ide/util/TreeJavaClassChooserDialog", "getInheritorsProvider"));
        }
        JavaInheritorsProvider javaInheritorsProvider = new JavaInheritorsProvider(this.getProject(), baseClass, this.getScope());
        if (javaInheritorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeJavaClassChooserDialog", "getInheritorsProvider"));
        }
        return javaInheritorsProvider;
    }

    public static class InheritanceJavaClassFilterImpl
    implements ClassFilter {
        private final PsiClass myBase;
        private final boolean myAcceptsSelf;
        private final boolean myAcceptsInner;
        @NotNull
        private final Condition<? super PsiClass> myAdditionalCondition;

        public InheritanceJavaClassFilterImpl(PsiClass base, boolean acceptsSelf, boolean acceptInner, @Nullable Condition<? super PsiClass> additionalCondition) {
            this.myAcceptsSelf = acceptsSelf;
            this.myAcceptsInner = acceptInner;
            if (additionalCondition == null) {
                additionalCondition = Conditions.alwaysTrue();
            }
            this.myAdditionalCondition = additionalCondition;
            this.myBase = base;
        }

        public boolean isAccepted(PsiClass aClass) {
            if (!this.myAcceptsInner && !(aClass.getParent() instanceof PsiJavaFile)) {
                return false;
            }
            if (!this.myAdditionalCondition.value((Object)aClass)) {
                return false;
            }
            return this.myAcceptsSelf || !aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)this.myBase);
        }
    }

    private static class JavaInheritorsProvider
    extends AbstractTreeClassChooserDialog.BaseClassInheritorsProvider<PsiClass> {
        private final Project myProject;

        public JavaInheritorsProvider(Project project, PsiClass baseClass, GlobalSearchScope scope) {
            super(baseClass, scope);
            this.myProject = project;
        }

        @Override
        @NotNull
        protected Query<PsiClass> searchForInheritors(PsiClass baseClass, GlobalSearchScope searchScope, boolean checkDeep) {
            Query query = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)searchScope, (boolean)checkDeep);
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeJavaClassChooserDialog$JavaInheritorsProvider", "searchForInheritors"));
            }
            return query;
        }

        @Override
        protected boolean isInheritor(PsiClass clazz, PsiClass baseClass, boolean checkDeep) {
            return clazz.isInheritor(baseClass, checkDeep);
        }

        @Override
        protected String[] getNames() {
            return PsiShortNamesCache.getInstance((Project)this.myProject).getAllClassNames();
        }
    }
}

