/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.Content;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

abstract class CurrentFileTodosPanel
extends TodoPanel {
    CurrentFileTodosPanel(Project project, TodoPanelSettings settings, Content content) {
        super(project, settings, true, content);
        VirtualFile[] files = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        this.setFile(files.length == 0 ? null : PsiManager.getInstance((Project)this.myProject).findFile(files[0]));
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/CurrentFileTodosPanel$1", "selectionChanged"));
                }
                VirtualFile file2 = e.getNewFile();
                final PsiFile psiFile = file2 != null && file2.isValid() ? PsiManager.getInstance((Project)CurrentFileTodosPanel.this.myProject).findFile(file2) : null;
                DumbService.getInstance((Project)CurrentFileTodosPanel.this.myProject).smartInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CurrentFileTodosPanel.this.setFile(psiFile);
                    }
                });
            }
        });
    }

    private void setFile(PsiFile file2) {
        Object selectableElement;
        if (this.myProject == null || PsiManager.getInstance((Project)this.myProject).isDisposed()) {
            return;
        }
        if (file2 != null && this.getSelectedFile() == file2) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        CurrentFileTodosTreeBuilder builder = (CurrentFileTodosTreeBuilder)this.myTodoTreeBuilder;
        builder.setFile(file2);
        if (this.myTodoTreeBuilder.isUpdatable() && (selectableElement = builder.getTodoTreeStructure().getFirstSelectableElement()) != null) {
            builder.buildNodeForElement(selectableElement);
            DefaultMutableTreeNode node = builder.getNodeForElement(selectableElement);
            LOG.assertTrue(node != null);
            this.myTodoTreeBuilder.getTree().getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
        }
    }
}

