/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.AutoScrollToSourceOptionProvider;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CollapseAllToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.ExpandAllToolbarAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AutoScrollToSourceHandler;
import javax.swing.JComponent;
import javax.swing.JTree;

public class CommonActionsManagerImpl
extends CommonActionsManager {
    public AnAction createPrevOccurenceAction(OccurenceNavigator navigator) {
        return new PreviousOccurenceToolbarAction(navigator);
    }

    public AnAction createNextOccurenceAction(OccurenceNavigator navigator) {
        return new NextOccurenceToolbarAction(navigator);
    }

    public AnAction createExpandAllAction(TreeExpander expander) {
        return new ExpandAllToolbarAction(expander);
    }

    public AnAction createExpandAllAction(TreeExpander expander, JComponent component) {
        ExpandAllToolbarAction expandAllToolbarAction = new ExpandAllToolbarAction(expander);
        expandAllToolbarAction.registerCustomShortcutSet(expandAllToolbarAction.getShortcutSet(), component);
        return expandAllToolbarAction;
    }

    public AnAction createExpandAllHeaderAction(JTree tree) {
        AnAction action = this.createExpandAllAction((TreeExpander)new DefaultTreeExpander(tree), tree);
        action.getTemplatePresentation().setIcon(AllIcons.General.ExpandAll);
        action.getTemplatePresentation().setHoveredIcon(AllIcons.General.ExpandAllHover);
        return action;
    }

    public AnAction createCollapseAllAction(TreeExpander expander) {
        return new CollapseAllToolbarAction(expander);
    }

    public AnAction createCollapseAllAction(TreeExpander expander, JComponent component) {
        CollapseAllToolbarAction collapseAllToolbarAction = new CollapseAllToolbarAction(expander);
        collapseAllToolbarAction.registerCustomShortcutSet(collapseAllToolbarAction.getShortcutSet(), component);
        return collapseAllToolbarAction;
    }

    public AnAction createCollapseAllHeaderAction(JTree tree) {
        AnAction action = this.createCollapseAllAction((TreeExpander)new DefaultTreeExpander(tree), tree);
        action.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        action.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
        return action;
    }

    public AnAction createHelpAction(String helpId) {
        return new ContextHelpAction(helpId);
    }

    public AnAction installAutoscrollToSourceHandler(Project project, JTree tree, final AutoScrollToSourceOptionProvider optionProvider) {
        AutoScrollToSourceHandler handler2 = new AutoScrollToSourceHandler(){

            public boolean isAutoScrollMode() {
                return optionProvider.isAutoScrollMode();
            }

            public void setAutoScrollMode(boolean state) {
                optionProvider.setAutoScrollMode(state);
            }
        };
        handler2.install(tree);
        return handler2.createToggleAction();
    }

    public AnAction createExportToTextFileAction(ExporterToTextFile exporter) {
        return new ExportToTextFileToolbarAction(exporter);
    }
}

