/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    @Override
    public boolean handlesTemplate(FileTemplate template) {
        return true;
    }

    @Override
    @NotNull
    public PsiElement createFromTemplate(Project project, PsiDirectory directory, String fileName, FileTemplate template, String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        if (props == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props", "com/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler", "createFromTemplate"));
        }
        fileName = this.checkAppendExtension(fileName, template);
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            throw new IncorrectOperationException("This filename is ignored (Settings | Editor | File Types | Ignore files and folders)");
        }
        directory.checkCreateFile(fileName);
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, type, (CharSequence)templateText);
        if (template.isReformatCode()) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2);
        }
        PsiFile psiFile = file2 = (PsiFile)directory.add((PsiElement)file2);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler", "createFromTemplate"));
        }
        return psiFile;
    }

    protected String checkAppendExtension(String fileName, FileTemplate template) {
        String suggestedFileNameEnd = "." + template.getExtension();
        if (!fileName.endsWith(suggestedFileNameEnd)) {
            fileName = fileName + suggestedFileNameEnd;
        }
        return fileName;
    }

    @Override
    public boolean canCreate(PsiDirectory[] dirs) {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    @Override
    public void prepareProperties(Map<String, Object> props) {
    }
}

