/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebBrowserServiceImpl
extends WebBrowserService {
    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl) throws WebBrowserUrlProvider.BrowserException {
        VirtualFile file2;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
        }
        boolean isHtmlOrXml = WebBrowserServiceImpl.isHtmlOrXmlFile((Language)request.getFile().getViewProvider().getBaseLanguage());
        if (!preferLocalUrl || !isHtmlOrXml) {
            DumbService dumbService = DumbService.getInstance((Project)request.getProject());
            for (WebBrowserUrlProvider urlProvider : (WebBrowserUrlProvider[])WebBrowserUrlProvider.EP_NAME.getExtensions()) {
                Collection<Url> urls;
                if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request) || (urls = WebBrowserServiceImpl.getUrls(urlProvider, request)).isEmpty()) continue;
                Collection<Url> collection = urls;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
                }
                return collection;
            }
            if (!isHtmlOrXml) {
                List<Url> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
                }
                return list;
            }
        }
        List<Url> list = (file2 = request.getVirtualFile()) instanceof LightVirtualFile || !request.getFile().getViewProvider().isPhysical() ? Collections.emptyList() : Collections.singletonList(Urls.newFromVirtualFile(file2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
        }
        return list;
    }

    @NotNull
    private static Collection<Url> getUrls(@Nullable WebBrowserUrlProvider provider, @NotNull OpenInBrowserRequest request) throws WebBrowserUrlProvider.BrowserException {
        block8: {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrls"));
            }
            if (provider != null) {
                Collection collection;
                if (request.getResult() != null) {
                    Collection collection2 = request.getResult();
                    if (collection2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrls"));
                    }
                    return collection2;
                }
                try {
                    collection = provider.getUrls(request);
                }
                catch (WebBrowserUrlProvider.BrowserException e) {
                    if (HtmlUtil.isHtmlFile((PsiElement)request.getFile())) break block8;
                    throw e;
                }
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrls"));
                }
                return collection;
            }
        }
        List<Url> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrls"));
        }
        return list;
    }

    @Nullable
    public static WebBrowserUrlProvider getProvider(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getProvider"));
        }
        DumbService dumbService = DumbService.getInstance((Project)request.getProject());
        for (WebBrowserUrlProvider urlProvider : (WebBrowserUrlProvider[])WebBrowserUrlProvider.EP_NAME.getExtensions()) {
            if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request)) continue;
            return urlProvider;
        }
        return null;
    }

    @NotNull
    public static Collection<Url> getDebuggableUrls(@Nullable PsiElement context) {
        Collection<Url> collection;
        try {
            OpenInBrowserRequest request = context == null ? null : OpenInBrowserRequest.create((PsiElement)context);
            collection = request == null || request.getFile().getViewProvider().getBaseLanguage() == XMLLanguage.INSTANCE ? Collections.emptyList() : WebBrowserServiceImpl.getUrls(WebBrowserServiceImpl.getProvider(request), request);
        }
        catch (WebBrowserUrlProvider.BrowserException ignored) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getDebuggableUrls"));
            }
            return list;
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getDebuggableUrls"));
        }
        return collection;
    }

    @Nullable
    public static Url getDebuggableUrl(@Nullable PsiElement context) {
        return (Url)ContainerUtil.getFirstItem(WebBrowserServiceImpl.getDebuggableUrls(context));
    }
}

