/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;

public class ToggleReadOnlyAttributeAction
extends AnAction
implements DumbAware {
    static VirtualFile[] getFiles(DataContext dataContext) {
        ArrayList filesList = ContainerUtil.newArrayList();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        for (int i = 0; files != null && i < files.length; ++i) {
            VirtualFile file2 = files[i];
            if (!file2.isInLocalFileSystem()) continue;
            filesList.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray((Collection)filesList);
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(files.length > 0);
        if (files.length > 0) {
            boolean allReadOnly = true;
            boolean allWritable = true;
            for (VirtualFile file2 : files) {
                if (file2.isWritable()) {
                    allReadOnly = false;
                    continue;
                }
                allWritable = false;
            }
            if (allReadOnly) {
                e.getPresentation().setText(files.length > 1 ? "Make Files Writable" : "Make File Writable");
            } else if (allWritable) {
                e.getPresentation().setText(files.length > 1 ? "Make Files Read-only" : "Make File Read-only");
            } else {
                e.getPresentation().setText("Toggle Read-only Attribute");
            }
        }
    }

    public void actionPerformed(final AnActionEvent e) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                try {
                    VirtualFile[] files;
                    for (VirtualFile file2 : files = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext())) {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file2, (boolean)file2.isWritable());
                    }
                }
                catch (IOException exc) {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
                    Messages.showMessageDialog((Project)project, (String)exc.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
            }
        });
    }
}

