/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class CloseEditorAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx editorManager = CloseEditorAction.getEditorManager(project);
        EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        VirtualFile file2 = null;
        if (window == null) {
            window = (EditorWindow)editorManager.getActiveWindow().getResult();
            if (window != null) {
                file2 = window.getSelectedFile();
            }
        } else {
            file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (file2 != null) {
            editorManager.closeFile(file2, window);
        }
    }

    private static FileEditorManagerEx getEditorManager(Project project) {
        return (FileEditorManagerEx)FileEditorManager.getInstance((Project)project);
    }

    public void update(AnActionEvent event) {
        EditorWindow window;
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        if ("EditorPopup".equals(event.getPlace()) || "EditorTabPopup".equals(event.getPlace())) {
            presentation.setText(IdeBundle.message((String)"action.close", (Object[])new Object[0]));
        }
        if ((window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) == null) {
            window = (EditorWindow)CloseEditorAction.getEditorManager(project).getActiveWindow().getResult();
        }
        presentation.setEnabled(window != null && window.getTabCount() > 0);
    }
}

