/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.analytics.AnalyticsUploader;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class SystemHealthMonitor
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, true);
    public static final AtomicLong ourStudioActionCount = new AtomicLong(0L);
    private static final String STUDIO_ACTIVITY_COUNT = "studio.activity.count";
    private static final AtomicLong ourStudioExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourInitialPersistedExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourNonBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final Object EXCEPTION_COUNT_LOCK = new Object();
    @NonNls
    private static final String STUDIO_EXCEPTION_COUNT_FILE = "studio.exc";
    @NonNls
    private static final String BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exb";
    @NonNls
    private static final String NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exp";
    private final PropertiesComponent myProperties;
    private static final int INITIAL_DELAY_MINUTES = 1;
    private static final int INTERVAL_IN_MINUTES = 30;

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/SystemHealthMonitor", "<init>"));
        }
        this.myProperties = properties;
    }

    public void initComponent() {
        this.checkJvm();
        this.checkIBus();
        this.checkJAyatana();
        SystemHealthMonitor.startDiskSpaceMonitoring();
        if (ApplicationManager.getApplication().isInternal() || StatisticsUploadAssistant.isSendAllowed()) {
            ourStudioActionCount.set(this.myProperties.getOrInitLong(STUDIO_ACTIVITY_COUNT, 0L));
            ourStudioExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE));
            ourInitialPersistedExceptionCount.set(ourStudioExceptionCount.get());
            ourBundledPluginsExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
            ourNonBundledPluginsExceptionCount.set(SystemHealthMonitor.getPersistedExceptionCount(NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
            StudioCrashDetection.updateRecordedVersionNumber((String)ApplicationInfo.getInstance().getStrictVersion());
            SystemHealthMonitor.startActivityMonitoring();
            AnalyticsUploader.trackCrashes(StudioCrashDetection.reapCrashDescriptions());
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect((Disposable)application).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

                @Override
                public void appClosing() {
                    SystemHealthMonitor.this.myProperties.setValue(SystemHealthMonitor.STUDIO_ACTIVITY_COUNT, Long.toString(ourStudioActionCount.get()));
                    StudioCrashDetection.stop();
                }
            });
        }
    }

    private void checkJvm() {
        if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK")) {
            this.showNotification("unsupported.jvm.openjdk.message");
        } else if (StringUtil.endsWithIgnoreCase((String)System.getProperty("java.version", ""), (String)"-ea")) {
            this.showNotification("unsupported.jvm.ea.message");
        }
        if (SystemInfoRt.isMac && !SystemInfo.isJetbrainsJvm && SystemInfo.isJavaVersionAtLeast((String)"1.8.0_60") && !SystemInfo.isJavaVersionAtLeast((String)"1.8.0_76")) {
            this.showNotification("unsupported.jvm.dragndrop.message");
        }
    }

    private void checkIBus() {
        String fix;
        Matcher m;
        String version;
        String xim;
        if (SystemInfo.isXWindow && (xim = System.getenv("XMODIFIERS")) != null && xim.contains("im=ibus") && (version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"ibus-daemon", "--version"}))) != null && (m = Pattern.compile("ibus-daemon - Version ([0-9.]+)").matcher(version)).find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"1.5.11") < 0 && ((fix = System.getenv("IBUS_ENABLE_SYNC_MODE")) == null || fix.isEmpty() || fix.equals("0") || fix.equalsIgnoreCase("false"))) {
            this.showNotification("ibus.blocking.warn.message");
        }
    }

    private void checkJAyatana() {
        String originalOpts;
        if (SystemInfo.isXWindow && (originalOpts = System.getenv("_ORIGINAL_JAVA_TOOL_OPTIONS")) != null && originalOpts.contains("jayatanaag.jar")) {
            this.showNotification("ayatana.menu.warn.message");
        }
    }

    private void showNotification(@PropertyKey(resourceBundle="messages.IdeBundle") String key) {
        final String ignoreKey = "ignore." + key;
        boolean ignored = this.myProperties.isValueSet(ignoreKey);
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        final String message = IdeBundle.message((String)key, (Object[])new Object[0]) + IdeBundle.message((String)"sys.health.acknowledge.link", (Object[])new Object[0]);
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appStarting(@Nullable Project projectFromCommandLine) {
                app.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListener.UrlOpeningListener notificationListener = new NotificationListener.UrlOpeningListener(false){

                            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                                if (notification == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/SystemHealthMonitor$2$1$1", "hyperlinkActivated"));
                                }
                                if (event == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/SystemHealthMonitor$2$1$1", "hyperlinkActivated"));
                                }
                                if ("ack".equals(event.getDescription())) {
                                    SystemHealthMonitor.this.myProperties.setValue(ignoreKey, "true");
                                    notification.expire();
                                } else {
                                    super.hyperlinkActivated(notification, event);
                                }
                            }
                        };
                        Notification notification = GROUP.createNotification("System Health", message, NotificationType.WARNING, (NotificationListener)notificationListener);
                        notification.setImportant(true);
                        Notifications.Bus.notify((Notification)notification);
                    }
                });
            }
        });
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<Long>(){

                            @Override
                            public Long call() throws Exception {
                                long fileUsableSpace = file2.getUsableSpace();
                                while (fileUsableSpace == 0L) {
                                    TimeoutUtil.sleep((long)5000L);
                                    fileUsableSpace = file2.getUsableSpace();
                                }
                                return fileUsableSpace;
                            }
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                        return;
                    }
                    try {
                        final long fileUsableSpace = (Long)future2.get();
                        final long timeout = Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L);
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (!this.notificationsComponentIsLoaded()) {
                                ourFreeSpaceCalculation.set(future2);
                                JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                    String message = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                    if (fileUsableSpace < 102400L) {
                                        LOG.warn(message + " (" + fileUsableSpace + ")");
                                        Messages.showErrorDialog((String)message, (String)"Fatal Configuration Problem");
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    } else {
                                        GROUP.createNotification(message, file2.getPath(), NotificationType.ERROR, null).whenExpired(new Runnable(){

                                            @Override
                                            public void run() {
                                                reported.compareAndSet(true, false);
                                                this.restart(timeout);
                                            }
                                        }).notify(null);
                                    }
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private boolean notificationsComponentIsLoaded() {
                return ApplicationManager.getApplication().runReadAction((Computable)new Computable<NotificationsConfiguration>(){

                    public NotificationsConfiguration compute() {
                        return NotificationsConfiguration.getNotificationsConfiguration();
                    }
                }) != null;
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private static void startActivityMonitoring() {
        JobScheduler.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long activityCount = ourStudioActionCount.getAndSet(0L);
                long exceptionCount = ourStudioExceptionCount.getAndSet(0L);
                long bundledPluginExceptionCount = ourBundledPluginsExceptionCount.getAndSet(0L);
                long nonBundledPluginExceptionCount = ourNonBundledPluginsExceptionCount.getAndSet(0L);
                SystemHealthMonitor.persistExceptionCount(0L, SystemHealthMonitor.STUDIO_EXCEPTION_COUNT_FILE);
                SystemHealthMonitor.persistExceptionCount(0L, SystemHealthMonitor.BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
                SystemHealthMonitor.persistExceptionCount(0L, SystemHealthMonitor.NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
                if (ApplicationManager.getApplication().isInternal()) assert (SystemHealthMonitor.getPersistedExceptionCount(SystemHealthMonitor.STUDIO_EXCEPTION_COUNT_FILE) < 5L);
                if (activityCount > 0L || exceptionCount > 0L) {
                    AnalyticsUploader.trackExceptionsAndActivity(activityCount, exceptionCount, bundledPluginExceptionCount, nonBundledPluginExceptionCount, 0L);
                    if (exceptionCount > 1000L) {
                        ImmutableMap parameters = ImmutableMap.builder().put((Object)"initCount", (Object)Long.toString(ourInitialPersistedExceptionCount.get())).put((Object)"locale", (Object)AnalyticsUploader.getLanguage()).put((Object)"osname", (Object)SystemInfo.OS_NAME).put((Object)"osver", (Object)SystemInfo.OS_VERSION).put((Object)"jre_version", (Object)SystemInfo.JAVA_RUNTIME_VERSION).put((Object)"last3exc", (Object)AnalyticsUploader.getLastExceptionDescription()).build();
                        AnalyticsUploader.postToGoogleLogs("excdetails", (Map<String, String>)parameters);
                    }
                }
            }
        }, 1L, 30L, TimeUnit.MINUTES);
    }

    public static void incrementAndSaveExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourStudioExceptionCount.incrementAndGet(), STUDIO_EXCEPTION_COUNT_FILE);
        if (ApplicationManager.getApplication().isInternal()) assert (Math.abs(SystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) - ourStudioExceptionCount.get()) < 5L);
    }

    public static void incrementAndSaveBundledPluginsExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourBundledPluginsExceptionCount.incrementAndGet(), BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    public static void incrementAndSaveNonBundledPluginsExceptionCount() {
        SystemHealthMonitor.persistExceptionCount(ourNonBundledPluginsExceptionCount.incrementAndGet(), NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void persistExceptionCount(long count, @NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "countFileName", "com/intellij/ide/SystemHealthMonitor", "persistExceptionCount"));
        }
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                void countFileName;
                File f = new File(PathManager.getTempPath(), (String)countFileName);
                Files.write((CharSequence)Long.toString(count), (File)f, (Charset)Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPersistedExceptionCount(@NotNull String countFileName) {
        if (countFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "countFileName", "com/intellij/ide/SystemHealthMonitor", "getPersistedExceptionCount"));
        }
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                File f = new File(PathManager.getTempPath(), countFileName);
                String contents = Files.toString((File)f, (Charset)Charsets.UTF_8);
                return Long.parseLong(contents);
            }
            catch (Throwable t) {
                return 0L;
            }
        }
    }
}

