/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.LightweightHint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUtil {
    private static final Key<Direction> KEY = Key.create((String)"FindUtil.KEY");

    private FindUtil() {
    }

    @Nullable
    static VirtualFile getVirtualFile(@NotNull Editor myEditor) {
        if (myEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myEditor", "com/intellij/find/FindUtil", "getVirtualFile"));
        }
        Project project = myEditor.getProject();
        PsiFile file2 = project != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(myEditor.getDocument()) : null;
        return file2 != null ? file2.getVirtualFile() : null;
    }

    public static void initStringToFindWithSelection(FindModel findModel, Editor editor) {
        String s;
        if (editor != null && (s = editor.getSelectionModel().getSelectedText()) != null && s.length() < 10000) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)s);
        }
    }

    private static boolean isMultilineSelection(Editor editor) {
        String selectedText;
        SelectionModel selectionModel;
        SelectionModel selectionModel2 = selectionModel = editor != null ? editor.getSelectionModel() : null;
        return selectionModel != null && (selectedText = selectionModel.getSelectedText()) != null && selectedText.contains("\n");
    }

    private static boolean isWholeLineSelection(Editor editor) {
        SelectionModel selectionModel;
        SelectionModel selectionModel2 = selectionModel = editor != null ? editor.getSelectionModel() : null;
        if (selectionModel != null) {
            int line;
            String selectedText = selectionModel.getSelectedText();
            Document document = editor.getDocument();
            String lineText = document.getText(new TextRange(document.getLineStartOffset(line = document.getLineNumber(selectionModel.getSelectionStart())), document.getLineEndOffset(line)));
            if (lineText.trim().equals(selectedText)) {
                return true;
            }
        }
        return false;
    }

    public static void configureFindModel(boolean replace, @Nullable Editor editor, FindModel model, boolean firstSearch) {
        String selectedText;
        boolean isGlobal = true;
        String stringToFind = null;
        SelectionModel selectionModel = editor != null ? editor.getSelectionModel() : null;
        String string = selectedText = selectionModel != null ? selectionModel.getSelectedText() : null;
        if (!StringUtil.isEmpty((String)selectedText)) {
            if (replace && (FindUtil.isMultilineSelection(editor) || FindUtil.isWholeLineSelection(editor))) {
                isGlobal = false;
                stringToFind = model.getStringToFind();
            } else if (FindUtil.isMultilineSelection(editor)) {
                model.setMultiline(true);
            }
            if (stringToFind == null) {
                stringToFind = selectedText;
            }
        } else {
            stringToFind = firstSearch ? "" : model.getStringToFind();
        }
        model.setReplaceState(replace);
        model.setStringToFind(stringToFind);
        model.setGlobal(isGlobal);
        model.setPromptOnReplace(false);
    }

    public static void updateFindInFileModel(@Nullable Project project, @NotNull FindModel with) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/intellij/find/FindUtil", "updateFindInFileModel"));
        }
        FindModel model = FindManager.getInstance((Project)project).getFindInFileModel();
        model.setCaseSensitive(with.isCaseSensitive());
        model.setWholeWordsOnly(with.isWholeWordsOnly());
        model.setRegularExpressions(with.isRegularExpressions());
        model.setSearchContext(with.getSearchContext());
        if (with.isReplaceState()) {
            model.setPreserveCase(with.isPreserveCase());
        }
    }

    public static void findWordAtCaret(Project project, Editor editor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int start = 0;
        int end = document.getTextLength();
        if (!editor.getSelectionModel().hasSelection()) {
            char c;
            int i;
            for (i = caretOffset - 1; i >= 0; --i) {
                c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                start = i + 1;
                break;
            }
            for (i = caretOffset; i < document.getTextLength(); ++i) {
                c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                end = i;
                break;
            }
        } else {
            start = editor.getSelectionModel().getSelectionStart();
            end = editor.getSelectionModel().getSelectionEnd();
        }
        if (start >= end) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        String s = text.subSequence(start, end).toString();
        FindSettings.getInstance().addStringToFind(s);
        findManager.getFindInFileModel().setStringToFind(s);
        findManager.setFindWasPerformed();
        findManager.clearFindingNextUsageInFile();
        FindModel model = new FindModel();
        model.setStringToFind(s);
        model.setCaseSensitive(true);
        model.setWholeWordsOnly(!editor.getSelectionModel().hasSelection());
        EditorSearchSession searchSession = EditorSearchSession.get(editor);
        if (searchSession != null) {
            searchSession.setTextInField(model.getStringToFind());
        }
        findManager.setFindNextModel(model);
        FindUtil.doSearch(project, editor, caretOffset, true, model, true);
    }

    public static void find(final @NotNull Project project, final @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "find"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "find"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final FindManager findManager = FindManager.getInstance((Project)project);
        String s = editor.getSelectionModel().getSelectedText();
        final FindModel model = findManager.getFindInFileModel().clone();
        if (StringUtil.isEmpty((String)s)) {
            model.setGlobal(true);
        } else if (s.indexOf(10) >= 0) {
            model.setGlobal(false);
        } else {
            model.setStringToFind(s);
            model.setGlobal(true);
        }
        model.setReplaceState(false);
        model.setFindAllEnabled(PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
        findManager.showFindDialog(model, new Runnable(){

            @Override
            public void run() {
                int offset;
                if (model.isFindAll()) {
                    findManager.setFindNextModel(model);
                    FindUtil.findAllAndShow(project, editor, model);
                    return;
                }
                if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                    offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                    ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                    FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
                }
                if (model.isGlobal()) {
                    offset = model.isFromCursor() ? editor.getCaretModel().getOffset() : (model.isForward() ? 0 : editor.getDocument().getTextLength());
                } else {
                    if (!editor.getSelectionModel().hasSelection()) {
                        findManager.setFindNextModel(null);
                        return;
                    }
                    offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                }
                findManager.setFindNextModel(null);
                findManager.getFindInFileModel().copyFrom(model);
                FindUtil.doSearch(project, editor, offset, true, model, true);
            }
        });
    }

    @Nullable
    public static List<Usage> findAll(@NotNull Project project, @NotNull Editor editor, @NotNull FindModel findModel) {
        FindResult result2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "findAll"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "findAll"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/FindUtil", "findAll"));
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        CharSequence text = document.getCharsSequence();
        int textLength = document.getTextLength();
        ArrayList<Usage> usages = new ArrayList<Usage>();
        FindManager findManager = FindManager.getInstance((Project)project);
        findModel.setForward(true);
        int offset = 0;
        VirtualFile virtualFile = FindUtil.getVirtualFile(editor);
        while (offset < textLength && (result2 = findManager.findString(text, offset, findModel, virtualFile)).isStringFound()) {
            usages.add((Usage)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, result2.getStartOffset(), result2.getEndOffset())));
            int prevOffset = offset;
            if (prevOffset != (offset = result2.getEndOffset())) continue;
            ++offset;
        }
        return usages;
    }

    public static void findAllAndShow(@NotNull Project project, @NotNull Editor editor, @NotNull FindModel findModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "findAllAndShow"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "findAllAndShow"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/FindUtil", "findAllAndShow"));
        }
        List<Usage> usages = FindUtil.findAll(project, editor, findModel);
        if (usages == null) {
            return;
        }
        UsageTarget[] usageTargets = new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(project, findModel)};
        UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation(false, findModel);
        UsageViewManager.getInstance((Project)project).showUsages(usageTargets, usages.toArray(new Usage[usages.size()]), usageViewPresentation);
    }

    public static void searchBack(Project project, FileEditor fileEditor, @Nullable DataContext dataContext) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        FindUtil.searchBack(project, editor, dataContext);
    }

    public static void searchBack(Project project, Editor editor, @Nullable DataContext context) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor, context);
            return;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model.setForward(!(model = model.clone()).isForward());
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else {
            editor.putUserData(KEY, null);
            offset = editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        FindUtil.searchAgain(project, editor, offset, model);
    }

    public static boolean searchAgain(Project project, FileEditor fileEditor, @Nullable DataContext context) {
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        return FindUtil.searchAgain(project, editor, context);
    }

    public static boolean searchAgain(Project project, Editor editor, @Nullable DataContext context) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor, context);
            return false;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model = model.clone();
        if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else {
            editor.putUserData(KEY, null);
            int n = offset = model.isGlobal() && model.isForward() ? editor.getSelectionModel().getSelectionEnd() : editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        return FindUtil.searchAgain(project, editor, offset, model);
    }

    private static boolean searchAgain(Project project, Editor editor, int offset, FindModel model) {
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        model.setFromCursor(false);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            FindUtil.replace(project, editor, offset, model);
            return true;
        }
        FindUtil.doSearch(project, editor, offset, true, model, true);
        return false;
    }

    public static void replace(final Project project, final Editor editor) {
        final FindManager findManager = FindManager.getInstance((Project)project);
        final FindModel model = findManager.getFindInFileModel().clone();
        final String s = editor.getSelectionModel().getSelectedText();
        if (!StringUtil.isEmpty((String)s)) {
            if (s.indexOf(10) >= 0) {
                model.setGlobal(false);
            } else {
                model.setStringToFind(s);
                model.setGlobal(true);
            }
        } else {
            model.setGlobal(true);
        }
        model.setReplaceState(true);
        findManager.showFindDialog(model, new Runnable(){

            @Override
            public void run() {
                int offset;
                if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                    offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                    ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                    FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
                }
                if (model.isGlobal()) {
                    if (model.isFromCursor()) {
                        offset = editor.getCaretModel().getOffset();
                        if (!model.isForward()) {
                            ++offset;
                        }
                    } else {
                        offset = model.isForward() ? 0 : editor.getDocument().getTextLength();
                    }
                } else {
                    if (!editor.getSelectionModel().hasSelection()) {
                        findManager.setFindNextModel(null);
                        return;
                    }
                    int n = offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                }
                if (s != null && editor.getSelectionModel().hasSelection() && s.equals(model.getStringToFind())) {
                    if (model.isFromCursor() && model.isForward()) {
                        offset = Math.min(editor.getSelectionModel().getSelectionStart(), offset);
                    } else if (model.isFromCursor() && !model.isForward()) {
                        offset = Math.max(editor.getSelectionModel().getSelectionEnd(), offset);
                    }
                }
                findManager.setFindNextModel(null);
                findManager.getFindInFileModel().copyFrom(model);
                FindUtil.replace(project, editor, offset, model);
            }
        });
    }

    public static boolean replace(Project project, Editor editor, int offset, FindModel model) {
        return FindUtil.replace(project, editor, offset, model, new ReplaceDelegate(){

            @Override
            public boolean shouldReplace(TextRange range, String replace) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(Project project, Editor editor, int offset, FindModel model, ReplaceDelegate delegate) {
        Document document = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
            return false;
        }
        document.startGuardedBlockChecking();
        boolean toPrompt = model.isPromptOnReplace();
        try {
            FindUtil.doReplace(project, editor, model, document, offset, toPrompt, delegate);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
        }
        return true;
    }

    private static void doReplace(Project project, final Editor editor, FindModel aModel, final Document document, int caretOffset, boolean toPrompt, ReplaceDelegate delegate) {
        FindManager findManager = FindManager.getInstance((Project)project);
        final FindModel model = aModel.clone();
        int occurrences = 0;
        ArrayList<Pair<TextRange, String>> rangesToChange = new ArrayList<Pair<TextRange, String>>();
        boolean replaced = false;
        boolean reallyReplaced = false;
        int offset = caretOffset;
        while (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            int newOffset;
            String toReplace;
            caretOffset = offset;
            FindResult result2 = FindUtil.doSearch(project, editor, offset, !replaced, model, toPrompt);
            if (result2 == null) break;
            int startResultOffset = result2.getStartOffset();
            model.setFromCursor(true);
            int startOffset = result2.getStartOffset();
            int endOffset = result2.getEndOffset();
            String string = document.getCharsSequence().subSequence(startOffset, endOffset).toString();
            try {
                toReplace = findManager.getStringToReplace(string, model, startOffset, document.getCharsSequence());
            }
            catch (FindManager.MalformedReplacementStringException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break;
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                break;
            }
            if (toPrompt) {
                int promptResult = findManager.showPromptDialog(model, FindBundle.message("find.replace.dialog.title", new Object[0]));
                if (promptResult == 2) {
                    offset = model.isForward() ? result2.getEndOffset() : startResultOffset;
                    continue;
                }
                if (promptResult == 1) break;
                if (promptResult == 3) {
                    toPrompt = false;
                }
            }
            if (delegate == null || delegate.shouldReplace((TextRange)result2, toReplace)) {
                if (toPrompt && !reallyReplaced) {
                    editor.getCaretModel().moveToOffset(0);
                    reallyReplaced = true;
                }
                TextRange textRange = FindUtil.doReplace(project, document, model, result2, toReplace, toPrompt, rangesToChange);
                replaced = true;
                newOffset = model.isForward() ? textRange.getEndOffset() : textRange.getStartOffset();
                ++occurrences;
            } else {
                int n = newOffset = model.isForward() ? result2.getEndOffset() : result2.getStartOffset();
            }
            if (newOffset == offset) {
                newOffset += model.isForward() ? 1 : -1;
            }
            offset = newOffset;
        }
        if (replaced) {
            if (!toPrompt) {
                CharSequence text = document.getCharsSequence();
                final StringBuilder newText = new StringBuilder(document.getTextLength());
                Collections.sort(rangesToChange, new Comparator<Pair<TextRange, String>>(){

                    @Override
                    public int compare(Pair<TextRange, String> o1, Pair<TextRange, String> o2) {
                        return ((TextRange)o1.getFirst()).getStartOffset() - ((TextRange)o2.getFirst()).getStartOffset();
                    }
                });
                int offsetBefore = 0;
                for (Pair pair : rangesToChange) {
                    TextRange range = (TextRange)pair.getFirst();
                    String replace = (String)pair.getSecond();
                    newText.append(text, offsetBefore, range.getStartOffset());
                    if (delegate == null || delegate.shouldReplace(range, replace)) {
                        newText.append(replace);
                    } else {
                        newText.append(text.subSequence(range.getStartOffset(), range.getEndOffset()));
                    }
                    if ((offsetBefore = range.getEndOffset()) >= caretOffset) continue;
                    caretOffset += replace.length() - range.getLength();
                }
                newText.append(text, offsetBefore, text.length());
                if (caretOffset > newText.length()) {
                    caretOffset = newText.length();
                }
                final int finalCaretOffset = caretOffset;
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                document.setText((CharSequence)newText);
                                editor.getCaretModel().moveToOffset(finalCaretOffset);
                                if (model.isGlobal()) {
                                    editor.getSelectionModel().removeSelection();
                                }
                            }
                        });
                    }
                }, null, (Object)document);
            } else if (reallyReplaced) {
                if (caretOffset > document.getTextLength()) {
                    caretOffset = document.getTextLength();
                }
                editor.getCaretModel().moveToOffset(caretOffset);
            }
        }
        ReplaceInProjectManager.reportNumberReplacedOccurrences(project, occurrences);
    }

    private static boolean selectionMayContainRange(SelectionModel selection, TextRange range) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        if (starts.length == 0) {
            return false;
        }
        return new TextRange(starts[0], ends[starts.length - 1]).contains(range);
    }

    private static boolean selectionStrictlyContainsRange(SelectionModel selection, TextRange range) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        for (int i = 0; i < starts.length; ++i) {
            if (!new TextRange(starts[i], ends[i]).contains(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static FindResult doSearch(@NotNull Project project, final @NotNull Editor editor, int offset, boolean toWarn, @NotNull FindModel model, boolean adjustEditor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "doSearch"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "doSearch"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/FindUtil", "doSearch"));
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        Document document = editor.getDocument();
        final FindResult result2 = findManager.findString(document.getCharsSequence(), offset, model, FindUtil.getVirtualFile(editor));
        boolean isFound = result2.isStringFound();
        SelectionModel selection = editor.getSelectionModel();
        if (isFound && !model.isGlobal()) {
            if (!FindUtil.selectionMayContainRange(selection, (TextRange)result2)) {
                isFound = false;
            } else if (!FindUtil.selectionStrictlyContainsRange(selection, (TextRange)result2)) {
                int[] starts;
                for (int newOffset : starts = selection.getBlockSelectionStarts()) {
                    if (newOffset <= result2.getStartOffset()) continue;
                    return FindUtil.doSearch(project, editor, newOffset, toWarn, model, adjustEditor);
                }
            }
        }
        if (!isFound) {
            if (toWarn) {
                FindUtil.processNotFound(editor, model.getStringToFind(), model, project);
            }
            return null;
        }
        if (adjustEditor) {
            ScrollType scrollType;
            CaretModel caretModel = editor.getCaretModel();
            final ScrollingModel scrollingModel = editor.getScrollingModel();
            int oldCaretOffset = caretModel.getOffset();
            boolean forward = oldCaretOffset < result2.getStartOffset();
            ScrollType scrollType2 = scrollType = forward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            if (model.isGlobal()) {
                int targetCaretPosition = result2.getEndOffset();
                if (selection.getSelectionEnd() - selection.getSelectionStart() == result2.getLength()) {
                    targetCaretPosition = caretModel.getOffset() - selection.getSelectionStart() + result2.getStartOffset();
                }
                if (caretModel.getCaretAt(editor.offsetToVisualPosition(targetCaretPosition)) != null) {
                    return result2;
                }
                caretModel.moveToOffset(targetCaretPosition);
                selection.removeSelection();
                scrollingModel.scrollToCaret(scrollType);
                scrollingModel.runActionOnScrollingFinished(new Runnable(){

                    @Override
                    public void run() {
                        scrollingModel.scrollTo(editor.offsetToLogicalPosition(result2.getStartOffset()), scrollType);
                        scrollingModel.scrollTo(editor.offsetToLogicalPosition(result2.getEndOffset()), scrollType);
                    }
                });
            } else {
                FindUtil.moveCaretAndDontChangeSelection(editor, result2.getStartOffset(), scrollType);
                FindUtil.moveCaretAndDontChangeSelection(editor, result2.getEndOffset(), scrollType);
            }
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes selectionAttributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (!model.isGlobal()) {
                RangeHighlighterEx segmentHighlighter = (RangeHighlighterEx)editor.getMarkupModel().addRangeHighlighter(result2.getStartOffset(), result2.getEndOffset(), 6001, selectionAttributes, HighlighterTargetArea.EXACT_RANGE);
                MyListener listener = new MyListener(editor, segmentHighlighter);
                caretModel.addCaretListener((CaretListener)listener);
            } else {
                selection.setSelection(result2.getStartOffset(), result2.getEndOffset());
            }
        }
        return result2;
    }

    public static void processNotFound(final Editor editor, String stringToFind, FindModel model, Project project) {
        String message = FindBundle.message("find.search.string.not.found.message", stringToFind);
        short position = 2;
        if (model.isGlobal()) {
            FindModel modelForNextSearch;
            Document document;
            FindModel newModel = model.clone();
            FindManager findManager = FindManager.getInstance((Project)project);
            FindResult result2 = findManager.findString((document = editor.getDocument()).getCharsSequence(), newModel.isForward() ? 0 : document.getTextLength(), model, FindUtil.getVirtualFile(editor));
            if (!result2.isStringFound()) {
                result2 = null;
            }
            if ((modelForNextSearch = findManager.getFindNextModel(editor)) == null) {
                modelForNextSearch = findManager.getFindInFileModel();
            }
            if (result2 != null) {
                AnAction action;
                if (newModel.isForward()) {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindNext" : "FindPrevious");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message = shortcutsText.length() > 0 ? FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.top.action.message", message);
                    editor.putUserData(KEY, (Object)Direction.DOWN);
                } else {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindPrevious" : "FindNext");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message = shortcutsText.length() > 0 ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message);
                    editor.putUserData(KEY, (Object)Direction.UP);
                    position = 1;
                }
            }
            CaretAdapter listener = new CaretAdapter(){

                public void caretPositionChanged(CaretEvent e) {
                    editor.putUserData(KEY, null);
                    editor.getCaretModel().removeCaretListener((CaretListener)this);
                }
            };
            editor.getCaretModel().addCaretListener((CaretListener)listener);
        }
        JComponent component = HintUtil.createInformationLabel(JDOMUtil.escapeText((String)message, (boolean)false, (boolean)false));
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, position, 42, 0, false);
    }

    public static TextRange doReplace(Project project, Document document, FindModel model, FindResult result2, @NotNull String stringToReplace, boolean reallyReplace, List<Pair<TextRange, String>> rangesToChange) {
        int start;
        int end;
        block9: {
            String toFind;
            block10: {
                block11: {
                    int newOffset;
                    if (stringToReplace == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToReplace", "com/intellij/find/FindUtil", "doReplace"));
                    }
                    int startOffset = result2.getStartOffset();
                    int endOffset = result2.getEndOffset();
                    if (reallyReplace) {
                        newOffset = FindUtil.doReplace(project, document, startOffset, endOffset, stringToReplace);
                    } else {
                        String converted = StringUtil.convertLineSeparators((String)stringToReplace);
                        TextRange textRange = new TextRange(startOffset, endOffset);
                        rangesToChange.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)converted));
                        newOffset = endOffset;
                    }
                    if (!model.isRegularExpressions()) break block9;
                    toFind = model.getStringToFind();
                    if (!model.isForward()) break block10;
                    if (!StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) break block11;
                    int i = 0;
                    int length = toFind.length();
                    while (i + 2 <= length && toFind.charAt(length - i - 2) == '\\') {
                        ++i;
                    }
                    if (i % 2 != 0) break block9;
                    ++end;
                    break block9;
                }
                if (!StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) break block9;
                for (end = newOffset; end < document.getTextLength() && document.getCharsSequence().charAt(end) != '\n'; ++end) {
                }
                break block9;
            }
            if (StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) {
                --start;
            } else if (StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) {
                for (start = startOffset; start >= 0 && document.getCharsSequence().charAt(start) != '\n'; --start) {
                }
            }
        }
        return new TextRange(start, end);
    }

    public static int doReplace(Project project, final Document document, final int startOffset, final int endOffset, String stringToReplace) {
        final String converted = StringUtil.convertLineSeparators((String)stringToReplace);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        document.replaceString(startOffset, endOffset, (CharSequence)converted);
                    }
                });
            }
        }, null, null);
        return startOffset + converted.length();
    }

    private static void moveCaretAndDontChangeSelection(Editor editor, int offset, ScrollType scrollType) {
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        editor.getCaretModel().moveToLogicalPosition(pos);
        editor.getScrollingModel().scrollToCaret(scrollType);
    }

    @Nullable
    public static UsageView showInUsageView(PsiElement sourceElement, @NotNull PsiElement[] targets, @NotNull String title, final @NotNull Project project) {
        PsiElement[] psiElementArray;
        UsageTarget[] usageTargetArray;
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/find/FindUtil", "showInUsageView"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/FindUtil", "showInUsageView"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "showInUsageView"));
        }
        if (targets.length == 0) {
            return null;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setCodeUsagesString(title);
        presentation.setTabName(title);
        presentation.setTabText(title);
        if (sourceElement == null) {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
        } else {
            UsageTarget[] usageTargetArray2 = new UsageTarget[1];
            usageTargetArray = usageTargetArray2;
            usageTargetArray2[0] = new PsiElement2UsageTargetAdapter(sourceElement);
        }
        UsageTarget[] usageTargets = usageTargetArray;
        if (sourceElement == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = sourceElement;
        }
        final PsiElement[] primary = psiElementArray;
        Usage[] usages = new Usage[]{UsageInfoToUsageConverter.convert((PsiElement[])primary, (UsageInfo)new UsageInfo(targets[0]))};
        final UsageView view = UsageViewManager.getInstance((Project)project).showUsages(usageTargets, usages, presentation);
        final List pointers = ContainerUtil.map((Object[])targets, (Function)new Function<PsiElement, SmartPsiElementPointer>(){

            public SmartPsiElementPointer fun(PsiElement psiElement) {
                return SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(psiElement);
            }
        });
        targets = PsiElement.EMPTY_ARRAY;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Updating Usage View ..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/FindUtil$10", "run"));
                }
                for (final SmartPsiElementPointer pointer : pointers) {
                    if (((UsageViewImpl)view).isDisposed()) break;
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiElement target = pointer.getElement();
                            if (target != null) {
                                view.appendUsage(UsageInfoToUsageConverter.convert((PsiElement[])primary, (UsageInfo)new UsageInfo(target)));
                            }
                        }
                    });
                }
            }
        });
        return view;
    }

    public static void selectSearchResultsInEditor(@NotNull Editor editor, @NotNull Iterator<FindResult> resultIterator, int caretShiftFromSelectionStart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "selectSearchResultsInEditor"));
        }
        if (resultIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultIterator", "com/intellij/find/FindUtil", "selectSearchResultsInEditor"));
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return;
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            FindResult findResult = resultIterator.next();
            int caretOffset = FindUtil.getCaretPosition(findResult, caretShiftFromSelectionStart);
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible(editor, caretOffset);
            EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
            EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
            caretStates.add(new CaretState(editor.offsetToLogicalPosition(caretOffset), editor.offsetToLogicalPosition(selectionStartOffset), editor.offsetToLogicalPosition(selectionEndOffset)));
        }
        if (caretStates.isEmpty()) {
            return;
        }
        editor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    public static boolean selectSearchResultInEditor(@NotNull Editor editor, @NotNull FindResult result2, int caretShiftFromSelectionStart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "selectSearchResultInEditor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/find/FindUtil", "selectSearchResultInEditor"));
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return false;
        }
        int caretOffset = FindUtil.getCaretPosition(result2, caretShiftFromSelectionStart);
        EditorActionUtil.makePositionVisible(editor, caretOffset);
        Caret newCaret = editor.getCaretModel().addCaret(editor.offsetToVisualPosition(caretOffset));
        if (newCaret == null) {
            return false;
        }
        int selectionStartOffset = result2.getStartOffset();
        int selectionEndOffset = result2.getEndOffset();
        EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
        EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
        newCaret.setSelection(selectionStartOffset, selectionEndOffset);
        return true;
    }

    private static int getCaretPosition(FindResult findResult, int caretShiftFromSelectionStart) {
        return caretShiftFromSelectionStart < 0 ? findResult.getEndOffset() : Math.min(findResult.getStartOffset() + caretShiftFromSelectionStart, findResult.getEndOffset());
    }

    public static interface ReplaceDelegate {
        public boolean shouldReplace(TextRange var1, String var2);
    }

    private static class MyListener
    extends CaretAdapter {
        private final Editor myEditor;
        private final RangeHighlighter mySegmentHighlighter;

        private MyListener(@NotNull Editor editor, @NotNull RangeHighlighter segmentHighlighter) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil$MyListener", "<init>"));
            }
            if (segmentHighlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/find/FindUtil$MyListener", "<init>"));
            }
            this.myEditor = editor;
            this.mySegmentHighlighter = segmentHighlighter;
        }

        public void caretPositionChanged(CaretEvent e) {
            this.removeAll();
        }

        private void removeAll() {
            this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
            this.mySegmentHighlighter.dispose();
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

