/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.impl.CacheDiffRequestChainProcessor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffWindowBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffWindow
extends DiffWindowBase {
    @NotNull
    private final DiffRequestChain myRequestChain;

    public DiffWindow(@Nullable Project project, @NotNull DiffRequestChain requestChain, @NotNull DiffDialogHints hints) {
        if (requestChain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestChain", "com/intellij/diff/impl/DiffWindow", "<init>"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/impl/DiffWindow", "<init>"));
        }
        super(project, hints);
        this.myRequestChain = requestChain;
    }

    @Override
    @NotNull
    protected DiffRequestProcessor createProcessor() {
        MyCacheDiffRequestChainProcessor myCacheDiffRequestChainProcessor = new MyCacheDiffRequestChainProcessor(this.myProject, this.myRequestChain);
        if (myCacheDiffRequestChainProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffWindow", "createProcessor"));
        }
        return myCacheDiffRequestChainProcessor;
    }

    private class MyCacheDiffRequestChainProcessor
    extends CacheDiffRequestChainProcessor {
        public MyCacheDiffRequestChainProcessor(@NotNull Project project, DiffRequestChain requestChain) {
            if (requestChain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestChain", "com/intellij/diff/impl/DiffWindow$MyCacheDiffRequestChainProcessor", "<init>"));
            }
            super(project, requestChain);
        }

        @Override
        protected void setWindowTitle(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/impl/DiffWindow$MyCacheDiffRequestChainProcessor", "setWindowTitle"));
            }
            DiffWindow.this.getWrapper().setTitle(title);
        }

        @Override
        protected void onAfterNavigate() {
            DiffUtil.closeWindow(DiffWindow.this.getWrapper().getWindow(), true, true);
        }
    }
}

