/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VMOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.VMOptions");
    @NonNls
    static final String XMX_OPTION_NAME = "Xmx";
    @NonNls
    static final String PERM_GEN_OPTION_NAME = "XX:MaxPermSize";
    @NonNls
    static final String CODE_CACHE_OPTION_NAME = "XX:ReservedCodeCacheSize";
    @NonNls
    static final String MAC_ARCH_VM_OPTIONS = SystemInfo.is64Bit ? "VMOptions.x86_64" : "VMOptions.i386";
    @NonNls
    private static final String XMX_OPTION = "-Xmx";
    @NonNls
    private static final String PERM_GEN_OPTION = "-XX:MaxPermSize=";
    @NonNls
    private static final String CODE_CACHE_OPTION = "-XX:ReservedCodeCacheSize=";
    @NonNls
    private static final String MEM_SIZE_EXPR = "(\\d*)([a-zA-Z]*)";
    @NonNls
    private static final Pattern XMX_PATTERN = Pattern.compile("-Xmx(\\d*)([a-zA-Z]*)");
    @NonNls
    private static final Pattern PERM_GEN_PATTERN = Pattern.compile("-XX:MaxPermSize=(\\d*)([a-zA-Z]*)");
    @NonNls
    private static final Pattern CODE_CACHE_PATTERN = Pattern.compile("-XX:ReservedCodeCacheSize=(\\d*)([a-zA-Z]*)");
    private static String ourTestPath;

    public static int readXmx() {
        return VMOptions.readOption(XMX_PATTERN);
    }

    public static int readMaxPermGen() {
        return VMOptions.readOption(PERM_GEN_PATTERN);
    }

    public static int readCodeCache() {
        return VMOptions.readOption(CODE_CACHE_PATTERN);
    }

    public static void writeXmx(int value) {
        VMOptions.writeOption(XMX_OPTION, value, XMX_PATTERN);
    }

    public static void writeMaxPermGen(int value) {
        VMOptions.writeOption(PERM_GEN_OPTION, value, PERM_GEN_PATTERN);
    }

    public static void writeCodeCache(int value) {
        VMOptions.writeOption(CODE_CACHE_OPTION, value, CODE_CACHE_PATTERN);
    }

    @Nullable
    public static String read() {
        File file2 = VMOptions.getReadFile();
        if (file2 == null) {
            return null;
        }
        try {
            return FileUtil.loadFile((File)file2);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private static int readOption(Pattern pattern) {
        String content = VMOptions.read();
        if (content == null) {
            return -1;
        }
        Matcher m = pattern.matcher(content);
        if (!m.find()) {
            return -1;
        }
        String valueString = m.group(1);
        String unitString = m.group(2);
        try {
            int value = Integer.parseInt(valueString);
            double multiplier = VMOptions.parseUnit(unitString);
            return (int)((double)value * multiplier);
        }
        catch (NumberFormatException e) {
            LOG.info((Throwable)e);
            return -1;
        }
    }

    private static double parseUnit(String unitString) {
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"k")) {
            return 9.765625E-4;
        }
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"g")) {
            return 1024.0;
        }
        return 1.0;
    }

    private static void writeOption(String option, int value, Pattern pattern) {
        File file2 = VMOptions.getWriteFile();
        if (file2 == null) {
            return;
        }
        try {
            String optionValue = option + value + "m";
            String content = VMOptions.read();
            if (content == null) {
                content = "";
            }
            content = VMOptions.replace(pattern, content, optionValue, "", "", content + " " + optionValue);
            if (file2.exists()) {
                FileUtil.setReadOnlyAttribute((String)file2.getPath(), (boolean)false);
            }
            byte[] bytes = content.getBytes();
            FileUtil.writeToFile((File)file2, (byte[])bytes);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static String replace(Pattern pattern, String text, String replacement, String prefix, String suffix, String defaultResult) {
        Matcher m = pattern.matcher(text);
        if (!m.find()) {
            return defaultResult;
        }
        StringBuffer b = new StringBuffer();
        m.appendReplacement(b, prefix + Matcher.quoteReplacement(replacement) + suffix);
        m.appendTail(b);
        return b.toString();
    }

    @Nullable
    private static File getReadFile() {
        if (ourTestPath != null) {
            return new File(ourTestPath);
        }
        File custom = VMOptions.getCustomFile(true);
        if (custom != null) {
            return custom;
        }
        return VMOptions.getDefaultFile();
    }

    @Nullable
    public static File getWriteFile() {
        if (ourTestPath != null) {
            return new File(ourTestPath);
        }
        File custom = VMOptions.getCustomFile(false);
        if (custom != null) {
            return custom;
        }
        return VMOptions.getDefaultFile();
    }

    @Nullable
    public static File getDefaultFile() {
        File f = new File(VMOptions.doGetSettingsFilePath(false)).getAbsoluteFile();
        if (!f.exists()) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return f;
        }
    }

    @Nullable
    public static File getCustomFile(boolean ifExists) {
        File f = new File(VMOptions.doGetSettingsFilePath(true)).getAbsoluteFile();
        if (!f.exists()) {
            if (ifExists) {
                return null;
            }
            return f;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return f;
        }
    }

    @NotNull
    private static String doGetSettingsFilePath(boolean customLocation) {
        String[] optionsFiles;
        String vmOptionsFile;
        if (customLocation && !StringUtil.isEmptyOrSpaces((String)(vmOptionsFile = System.getProperty("jb.vmOptionsFile"))) && (optionsFiles = vmOptionsFile.split(",")).length > 1) {
            LOG.debug("doGetSettingsFilePath(true): " + optionsFiles[optionsFiles.length - 1]);
            String string = optionsFiles[optionsFiles.length - 1];
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/VMOptions", "doGetSettingsFilePath"));
            }
            return string;
        }
        String filePath = (customLocation ? PathManager.getConfigPath() : PathManager.getBinPath()) + File.separatorChar + VMOptions.getCustomFileName();
        LOG.debug("doGetSettingsFilePath(" + customLocation + "): " + filePath);
        String string = filePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/VMOptions", "doGetSettingsFilePath"));
        }
        return string;
    }

    @NotNull
    public static String getCustomFileName() {
        String name = ourTestPath != null ? "test" : ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        String platformSuffix = SystemInfo.is64Bit && !SystemInfo.isMac ? "64" : "";
        String osSuffix = SystemInfo.isWindows ? ".exe" : "";
        String string = name + platformSuffix + osSuffix + ".vmoptions";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/VMOptions", "getCustomFileName"));
        }
        return string;
    }

    static void setTestFile(String path) {
        ourTestPath = path;
    }

    static void clearTestFile() {
        ourTestPath = null;
    }
}

