/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightToolWindowManager
implements ProjectComponent {
    public static final String EDITOR_MODE = "UI_DESIGNER_EDITOR_MODE.";
    private final MergingUpdateQueue myWindowQueue = new MergingUpdateQueue(this.getComponentName(), 200, true, null);
    protected final Project myProject;
    protected final FileEditorManager myFileEditorManager;
    protected volatile ToolWindow myToolWindow;
    private volatile boolean myToolWindowDisposed;
    private final PropertiesComponent myPropertiesComponent;
    public final String myEditorModeKey;
    private ToggleEditorModeAction myLeftEditorModeAction;
    private ToggleEditorModeAction myRightEditorModeAction;
    private MessageBusConnection myConnection;
    private final FileEditorManagerListener myListener = new FileEditorManagerListener(){

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/LightToolWindowManager$1", "fileOpened"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/designer/LightToolWindowManager$1", "fileOpened"));
            }
            LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner());
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/designer/LightToolWindowManager$1", "fileClosed"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/designer/LightToolWindowManager$1", "fileClosed"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner());
                }
            });
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/designer/LightToolWindowManager$1", "selectionChanged"));
            }
            LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getDesigner(event.getNewEditor()));
        }
    };
    private final ParameterizedRunnable<DesignerEditorPanelFacade> myCreateAction = new ParameterizedRunnable<DesignerEditorPanelFacade>(){

        public void run(DesignerEditorPanelFacade designer) {
            designer.putClientProperty(LightToolWindowManager.this.getComponentName(), LightToolWindowManager.this.createContent(designer));
        }
    };
    private final ParameterizedRunnable<DesignerEditorPanelFacade> myUpdateAnchorAction = new ParameterizedRunnable<DesignerEditorPanelFacade>(){

        public void run(DesignerEditorPanelFacade designer) {
            LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(LightToolWindowManager.this.getComponentName());
            if (toolWindow != null) {
                toolWindow.updateAnchor(LightToolWindowManager.this.getEditorMode());
            }
        }
    };
    private final ParameterizedRunnable<DesignerEditorPanelFacade> myDisposeAction = new ParameterizedRunnable<DesignerEditorPanelFacade>(){

        public void run(DesignerEditorPanelFacade designer) {
            LightToolWindowManager.this.disposeContent(designer);
        }
    };

    protected LightToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myEditorModeKey = EDITOR_MODE + this.getComponentName() + ".STATE";
    }

    public void projectOpened() {
        this.initToolWindow();
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (LightToolWindowManager.this.getEditorMode() == null) {
                    LightToolWindowManager.this.initListeners();
                    LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner());
                }
            }
        });
    }

    public void projectClosed() {
        if (!this.myToolWindowDisposed) {
            this.disposeComponent();
            this.myToolWindowDisposed = true;
            this.myToolWindow = null;
        }
    }

    private void initListeners() {
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myListener);
    }

    private void removeListeners() {
        this.myConnection.disconnect();
        this.myConnection = null;
    }

    @Nullable
    protected abstract DesignerEditorPanelFacade getDesigner(FileEditor var1);

    @Nullable
    public DesignerEditorPanelFacade getActiveDesigner() {
        for (FileEditor editor : this.myFileEditorManager.getSelectedEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            return designer;
        }
        return null;
    }

    private void bindToDesigner(final DesignerEditorPanelFacade designer) {
        this.myWindowQueue.cancelAllUpdates();
        this.myWindowQueue.queue(new Update("update"){

            public void run() {
                if (LightToolWindowManager.this.myToolWindowDisposed) {
                    return;
                }
                if (LightToolWindowManager.this.myToolWindow == null) {
                    if (designer == null) {
                        return;
                    }
                    LightToolWindowManager.this.initToolWindow();
                }
                LightToolWindowManager.this.updateToolWindow(designer);
            }
        });
    }

    protected abstract void initToolWindow();

    protected abstract void updateToolWindow(@Nullable DesignerEditorPanelFacade var1);

    protected final void initGearActions() {
        ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{this.createGearActions()}));
    }

    protected abstract ToolWindowAnchor getAnchor();

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public AnAction createGearActions() {
        DefaultActionGroup group = new DefaultActionGroup("In Editor Mode", true);
        if (this.myLeftEditorModeAction == null) {
            this.myLeftEditorModeAction = this.createToggleAction(ToolWindowAnchor.LEFT);
        }
        group.add((AnAction)this.myLeftEditorModeAction);
        if (this.myRightEditorModeAction == null) {
            this.myRightEditorModeAction = this.createToggleAction(ToolWindowAnchor.RIGHT);
        }
        group.add((AnAction)this.myRightEditorModeAction);
        return group;
    }

    protected abstract ToggleEditorModeAction createToggleAction(ToolWindowAnchor var1);

    public final void bind(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/LightToolWindowManager", "bind"));
        }
        if (this.isEditorMode()) {
            this.myCreateAction.run((Object)designer);
        }
    }

    public final void dispose(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/LightToolWindowManager", "dispose"));
        }
        if (this.isEditorMode()) {
            this.disposeContent(designer);
        }
    }

    protected final Object getContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/LightToolWindowManager", "getContent"));
        }
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName());
        assert (toolWindow != null);
        return toolWindow.getContent();
    }

    protected abstract LightToolWindow createContent(@NotNull DesignerEditorPanelFacade var1);

    protected final LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer, @NotNull LightToolWindowContent content, @NotNull String title, @NotNull Icon icon, @NotNull JComponent component, @NotNull JComponent focusedComponent, int defaultWidth, @Nullable AnAction[] actions) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/LightToolWindowManager", "createContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/designer/LightToolWindowManager", "createContent"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/designer/LightToolWindowManager", "createContent"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/designer/LightToolWindowManager", "createContent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/designer/LightToolWindowManager", "createContent"));
        }
        if (focusedComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedComponent", "com/intellij/designer/LightToolWindowManager", "createContent"));
        }
        return new LightToolWindow(content, title, icon, component, focusedComponent, designer.getContentSplitter(), this.getEditorMode(), this, this.myProject, this.myPropertiesComponent, this.getComponentName(), defaultWidth, actions);
    }

    protected final void disposeContent(DesignerEditorPanelFacade designer) {
        String key = this.getComponentName();
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(key);
        designer.putClientProperty(key, null);
        if (toolWindow != null) {
            toolWindow.dispose();
        }
    }

    private void runUpdateContent(ParameterizedRunnable<DesignerEditorPanelFacade> action) {
        for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            action.run((Object)designer);
        }
    }

    protected final boolean isEditorMode() {
        return this.getEditorMode() != null;
    }

    @Nullable
    protected final ToolWindowAnchor getEditorMode() {
        String value = this.myPropertiesComponent.getValue(this.myEditorModeKey);
        if (value == null) {
            return this.getAnchor();
        }
        return value.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value);
    }

    protected final void setEditorMode(@Nullable ToolWindowAnchor newState) {
        ToolWindowAnchor oldState = this.getEditorMode();
        this.myPropertiesComponent.setValue(this.myEditorModeKey, newState == null ? "ToolWindow" : newState.toString());
        if (oldState != null && newState != null) {
            this.runUpdateContent(this.myUpdateAnchorAction);
        } else if (newState != null) {
            this.removeListeners();
            this.updateToolWindow(null);
            this.runUpdateContent(this.myCreateAction);
        } else {
            this.runUpdateContent(this.myDisposeAction);
            this.initListeners();
            this.bindToDesigner(this.getActiveDesigner());
        }
    }

    final ToolWindow getToolWindow() {
        return this.myToolWindow;
    }
}

