/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class LocalVariableEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator");
    private final String myLocalVariableName;
    private EvaluationContextImpl myContext;
    private LocalVariableProxyImpl myEvaluatedVariable;
    private final boolean myCanScanFrames;

    public LocalVariableEvaluator(String localVariableName, boolean canScanFrames) {
        this.myLocalVariableName = localVariableName;
        this.myCanScanFrames = canScanFrames;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.stackframe", (Object[])new Object[0]));
        }
        try {
            ThreadReferenceProxyImpl threadProxy = null;
            int lastFrameIndex = -1;
            Object variable = null;
            DebugProcessImpl process = context.getDebugProcess();
            boolean topFrame = true;
            while (true) {
                int currentFrameIndex;
                try {
                    LocalVariableProxyImpl local = frameProxy.visibleVariableByName(this.myLocalVariableName);
                    if (local != null && (topFrame || variable.equals(LocalVariableEvaluator.resolveVariable(frameProxy, this.myLocalVariableName, context.getProject(), process)))) {
                        this.myEvaluatedVariable = local;
                        this.myContext = context;
                        return frameProxy.getValue(local);
                    }
                }
                catch (EvaluateException e) {
                    if (!(e.getCause() instanceof AbsentInformationException)) {
                        throw e;
                    }
                    try {
                        Map<DecompiledLocalVariable, Value> vars = LocalVariablesUtil.fetchValues(frameProxy, process);
                        for (Map.Entry<DecompiledLocalVariable, Value> entry : vars.entrySet()) {
                            DecompiledLocalVariable var = entry.getKey();
                            if (!var.getMatchedNames().contains(this.myLocalVariableName) && !var.getDefaultName().equals(this.myLocalVariableName)) continue;
                            return entry.getValue();
                        }
                    }
                    catch (Exception e1) {
                        LOG.info((Throwable)e1);
                    }
                }
                if (!this.myCanScanFrames || topFrame && (variable = LocalVariableEvaluator.resolveVariable(frameProxy, this.myLocalVariableName, context.getProject(), process)) == null) break;
                if (threadProxy == null) {
                    threadProxy = frameProxy.threadProxy();
                    lastFrameIndex = threadProxy.frameCount() - 1;
                }
                if ((currentFrameIndex = frameProxy.getFrameIndex()) >= lastFrameIndex || (frameProxy = threadProxy.frame(currentFrameIndex + 1)) == null) break;
                topFrame = false;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.local.variable.missing", (Object[])new Object[]{this.myLocalVariableName}));
        }
        catch (EvaluateException e) {
            this.myEvaluatedVariable = null;
            this.myContext = null;
            throw e;
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if (this.myEvaluatedVariable != null && this.myContext != null) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    StackFrameProxyImpl frameProxy = LocalVariableEvaluator.this.myContext.getFrameProxy();
                    try {
                        assert (frameProxy != null);
                        frameProxy.setValue(LocalVariableEvaluator.this.myEvaluatedVariable, value);
                    }
                    catch (EvaluateException e) {
                        LOG.error((Throwable)e);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    try {
                        return LocalVariableEvaluator.this.myEvaluatedVariable.getType();
                    }
                    catch (EvaluateException e) {
                        LOG.error((Throwable)e);
                        return null;
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project) {
                    return new LocalVariableDescriptorImpl(project, LocalVariableEvaluator.this.myEvaluatedVariable);
                }
            };
        }
        return modifier;
    }

    @Nullable
    private static PsiVariable resolveVariable(final StackFrameProxy frame, final String name, final Project project, final DebugProcess process) {
        return (PsiVariable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiVariable>(){

            public PsiVariable compute() {
                PsiElement place = PositionUtil.getContextElement(new SimpleStackFrameContext(frame, process));
                if (place == null) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(name, place);
            }
        });
    }

    public String toString() {
        return this.myLocalVariableName;
    }
}

